/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileSystem;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePathType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

final class TrundlePath
implements Path {
    private static final String ABS_ROOT = "/";
    private static final String REL_ROOT = "";
    private final TrundleFileSystem fs;
    private final TrundlePathType pathType;
    private final String root;
    private final String path;
    private volatile int[] componentIndexes;
    private int hash;

    private TrundlePath(TrundleFileSystem fs, TrundlePathType pathType, String root, String path) {
        this.fs = Objects.requireNonNull(fs);
        this.pathType = Objects.requireNonNull(pathType);
        this.root = Objects.requireNonNull(root);
        this.path = TrundlePath.elideIfNeeded(root, Objects.requireNonNull(path));
        this.componentIndexes = null;
        this.hash = 0;
    }

    static TrundlePath of(TrundleFileSystem fs, String path) {
        Objects.requireNonNull(fs);
        Objects.requireNonNull(path);
        ParsedPath parsedPath = TrundlePath.parse(path);
        return new TrundlePath(fs, parsedPath.type(), parsedPath.root(), parsedPath.path());
    }

    private static ParsedPath parse(String path) {
        TrundlePathType type = path.length() > 0 && path.charAt(0) == '/' ? TrundlePathType.ABSOLUTE : TrundlePathType.RELATIVE;
        String root = TrundlePath.parseRoot(type, path);
        String rawPath = path.length() > 0 && type.isAbsolute() ? path.substring(1) : path;
        return new ParsedPath(type, root, rawPath.isEmpty() && type.isAbsolute() ? root : rawPath);
    }

    private static String parseRoot(TrundlePathType type, String path) {
        return type.isAbsolute() ? ABS_ROOT : REL_ROOT;
    }

    private static String normalize(String original) {
        StringBuilder builder = new StringBuilder();
        boolean foundSlash = true;
        boolean possiblyParent = false;
        boolean definitelyParent = false;
        int s = original.length();
        for (int i = 0; i < s; ++i) {
            char c = original.charAt(i);
            if (c == '/') {
                if (foundSlash) {
                    if (definitelyParent) {
                        int previousSlash = builder.lastIndexOf(ABS_ROOT);
                        builder.setLength(previousSlash);
                        possiblyParent = false;
                        definitelyParent = false;
                        continue;
                    }
                    if (possiblyParent) {
                        possiblyParent = false;
                        continue;
                    }
                    throw new InvalidPathException(original, "Invalid character in path", i);
                }
                foundSlash = true;
                continue;
            }
            if (c == '.') {
                if (foundSlash) {
                    if (definitelyParent) {
                        throw new InvalidPathException(original, "Invalid character in parent marker", i);
                    }
                    if (possiblyParent) {
                        definitelyParent = true;
                        continue;
                    }
                    possiblyParent = true;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (foundSlash) {
                builder.append('/');
                foundSlash = false;
            }
            builder.append(c);
        }
        return builder.substring(1);
    }

    private static String elideIfNeeded(String root, String path) {
        return root.equals(path) ? path : TrundlePath.elide(path);
    }

    private static String elide(String path) {
        int last;
        return !path.isEmpty() && path.charAt(last = path.length() - 1) == '/' ? path.substring(0, last) : path;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return this.pathType.isAbsolute();
    }

    @Override
    public Path getRoot() {
        if (this.root.isEmpty()) {
            return null;
        }
        return new TrundlePath(this.fs, this.pathType, this.root, this.root);
    }

    @Override
    public Path getFileName() {
        if (this.isEmptyPath()) {
            return this;
        }
        if (this.isRoot()) {
            return null;
        }
        int[] components = this.components();
        int lastComponentBegin = components[components.length - 2] + 1;
        String pathPortion = this.path.substring(lastComponentBegin);
        return new TrundlePath(this.fs, TrundlePathType.RELATIVE, REL_ROOT, pathPortion);
    }

    @Override
    public Path getParent() {
        if (this.isRoot()) {
            return null;
        }
        int[] components = this.components();
        int parentEnd = components[components.length - 2];
        String pathPortion = parentEnd == -1 ? this.root : this.path.substring(0, parentEnd);
        return new TrundlePath(this.fs, this.pathType, this.root, pathPortion);
    }

    @Override
    public int getNameCount() {
        if (this.isRoot()) {
            return 0;
        }
        return this.components().length - 1;
    }

    @Override
    @NotNull
    public Path getName(int index) {
        if (this.isRoot()) {
            throw new IllegalArgumentException(Integer.toString(index));
        }
        String portion = this.extract(index);
        return new TrundlePath(this.fs, TrundlePathType.RELATIVE, REL_ROOT, portion);
    }

    @Override
    @NotNull
    public Path subpath(int beginIndex, int endIndex) {
        if (this.isRoot()) {
            throw new IllegalArgumentException();
        }
        int[] components = this.components();
        if (beginIndex < 0 || beginIndex >= components.length - 1) {
            throw new IllegalArgumentException(Integer.toString(beginIndex));
        }
        if (endIndex < 0 || endIndex > components.length - 1) {
            throw new IllegalArgumentException(Integer.toString(endIndex));
        }
        String portion = this.path.substring(components[beginIndex] + 1, components[endIndex]);
        return new TrundlePath(this.fs, TrundlePathType.RELATIVE, REL_ROOT, portion);
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        Objects.requireNonNull(other);
        if (!(other instanceof TrundlePath)) {
            return false;
        }
        TrundlePath path = (TrundlePath)other;
        if (!this.root.equals(path.root)) {
            return false;
        }
        if (this.isEmptyPath()) {
            return path.isEmptyPath();
        }
        if (this.isRoot()) {
            return path.isRoot();
        }
        int pathCount = path.getNameCount();
        if (this.getNameCount() < pathCount) {
            return false;
        }
        for (int i = 0; i < pathCount; ++i) {
            String otherComponent;
            String ourComponent = this.extract(i);
            if (ourComponent.equals(otherComponent = path.extract(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        int pathCount;
        Objects.requireNonNull(other);
        if (!(other instanceof TrundlePath)) {
            return false;
        }
        TrundlePath path = (TrundlePath)other;
        if (this.root.isEmpty() && !path.root.isEmpty()) {
            return false;
        }
        if (!(this.root.isEmpty() || path.root.isEmpty() || this.root.equals(path.root))) {
            return false;
        }
        if (this.isEmptyPath()) {
            return path.isEmptyPath();
        }
        if (this.isRoot()) {
            return path.isRoot();
        }
        int ourCount = this.getNameCount();
        if (ourCount < (pathCount = path.getNameCount())) {
            return false;
        }
        for (int i = 0; i < pathCount; ++i) {
            String otherComponent;
            String ourComponent = this.extract(ourCount - 1 - i);
            if (ourComponent.equals(otherComponent = this.extract(pathCount - 1 - i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Path normalize() {
        if (this.isRoot() || this.isEmptyPath()) {
            return this;
        }
        return new TrundlePath(this.fs, this.pathType, this.root, TrundlePath.normalize(this.path));
    }

    @Override
    @NotNull
    public Path resolve(@NotNull Path other) {
        Objects.requireNonNull(other);
        if (!(other instanceof TrundlePath)) {
            throw new ProviderMismatchException();
        }
        TrundlePath path = (TrundlePath)other;
        if (path.isAbsolute()) {
            return path;
        }
        if (path.isEmptyPath()) {
            return this;
        }
        String resolvedPath = this.isRoot() ? path.path : this.path + ABS_ROOT + path.path;
        return new TrundlePath(this.fs, this.pathType, this.root, resolvedPath);
    }

    @Override
    @NotNull
    public Path relativize(@NotNull Path other) {
        Objects.requireNonNull(other);
        if (!(other instanceof TrundlePath)) {
            throw new ProviderMismatchException();
        }
        TrundlePath path = (TrundlePath)other;
        if (this.equals(other)) {
            return new TrundlePath(this.fs, TrundlePathType.RELATIVE, REL_ROOT, REL_ROOT);
        }
        boolean thisAbsolute = this.isAbsolute();
        if (thisAbsolute != path.isAbsolute()) {
            throw new IllegalArgumentException("Cannot relativize with mismatching path types");
        }
        if (this.isEmptyPath()) {
            return other;
        }
        int divergenceIndex = -1;
        int ourComponents = this.getNameCount();
        int theirComponents = path.getNameCount();
        int min = Math.min(ourComponents, theirComponents);
        for (int i = 0; i < min; ++i) {
            String theirComponent;
            String ourComponent = this.extract(i);
            if (ourComponent.equals(theirComponent = path.extract(i))) continue;
            divergenceIndex = i;
            break;
        }
        if (divergenceIndex == -1) {
            if (theirComponents < ourComponents) {
                String upwardsWalker = TrundlePath.elide("../".repeat(theirComponents - ourComponents));
                return new TrundlePath(this.fs, TrundlePathType.RELATIVE, REL_ROOT, upwardsWalker);
            }
            TrundlePath sub = (TrundlePath)path.subpath(ourComponents, theirComponents);
            return new TrundlePath(this.fs, TrundlePathType.RELATIVE, REL_ROOT, sub.path);
        }
        String upwardsWalker = "../".repeat(ourComponents - divergenceIndex);
        String sub = ((TrundlePath)path.subpath((int)divergenceIndex, (int)theirComponents)).path;
        return new TrundlePath(this.fs, TrundlePathType.RELATIVE, REL_ROOT, upwardsWalker + sub);
    }

    @Override
    @NotNull
    public URI toUri() {
        try {
            return new URI("%s:%s@%s%s".formatted("trundle", this.fs.name(), this.root, this.path));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        if (this.isEmptyPath()) {
            return new TrundlePath(this.fs, TrundlePathType.ABSOLUTE, ABS_ROOT, ABS_ROOT);
        }
        return new TrundlePath(this.fs, TrundlePathType.ABSOLUTE, ABS_ROOT, this.path);
    }

    @Override
    @NotNull
    public Path toRealPath(LinkOption ... options) {
        Objects.requireNonNull(options);
        return this.toAbsolutePath();
    }

    @Override
    @NotNull
    public WatchKey register(@NotNull WatchService watcher, @NotNull WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        Objects.requireNonNull(watcher);
        Objects.requireNonNull(events);
        Objects.requireNonNull(modifiers);
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public File toFile() {
        throw new UnsupportedOperationException("Unable to obtain a file from Trundle path");
    }

    @Override
    public int hashCode() {
        return this.hash == 0 ? (this.hash = Objects.hash(new Object[]{this.pathType, this.root, this.path})) : this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        TrundlePath other;
        return this == obj || obj instanceof TrundlePath && this.compareTo(other = (TrundlePath)obj) == 0;
    }

    @Override
    public String toString() {
        return this.isAbsolute() ? ABS_ROOT + (this.isRoot() ? REL_ROOT : this.path) : this.path;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        return this.compareTo((TrundlePath)Objects.requireNonNull(other));
    }

    SeekableByteChannel seekableByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attributes) throws IOException {
        return this.fs.seekableByteChannel(this.resolve(), options, attributes);
    }

    DirectoryStream<Path> directoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fs.directoryStream(this.resolve(), filter);
    }

    void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.fs.createDirectory(this.resolve(), attrs);
    }

    void delete() throws IOException {
        this.fs.delete(this.resolve());
    }

    void copy(TrundlePath to, CopyOption ... options) throws IOException {
        this.fs.copy(this.resolve(), to.resolve(), options);
    }

    void move(TrundlePath to, CopyOption ... options) throws IOException {
        this.fs.move(this.resolve(), to.resolve(), options);
    }

    boolean isSameFile(TrundlePath other) throws IOException {
        return this.fs.isSameFile(this.resolve(), other.resolve());
    }

    boolean isHidden() throws IOException {
        return this.fs.isHidden(this.resolve());
    }

    FileStore fileStore() throws IOException {
        return this.fs.fileStore(this.resolve());
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        this.fs.checkAccess(this.resolve(), modes);
    }

    <V extends FileAttributeView> V fileAttributeView(Class<V> type, LinkOption ... options) {
        return this.fs.fileAttributeView(this.resolve(), type, options);
    }

    <A extends BasicFileAttributes> A attributes(Class<A> type, LinkOption ... options) throws IOException {
        return this.fs.attributes(this.resolve(), type, options);
    }

    Map<String, Object> attributes(String attributes, LinkOption ... options) throws IOException {
        return this.fs.attributes(this.resolve(), attributes, options);
    }

    void attribute(String attribute, Object value, LinkOption ... options) throws IOException {
        this.fs.attribute(this.resolve(), attribute, value, options);
    }

    InputStream inputStream(OpenOption ... options) throws IOException {
        return this.fs.inputStream(this.resolve(), options);
    }

    OutputStream outputStream(OpenOption ... options) throws IOException {
        return this.fs.outputStream(this.resolve(), options);
    }

    FileChannel fileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.fs.fileChannel(this.resolve(), options, attrs);
    }

    AsynchronousFileChannel asyncFileChannel(Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        return this.fs.asyncFileChannel(this.resolve(), options, executor, attrs);
    }

    boolean deleteIfExists() throws IOException {
        return this.fs.deleteIfExist(this.resolve());
    }

    String[] pathPortions() {
        int[] components = this.components();
        String[] portions = new String[components.length - 1];
        int s = portions.length;
        for (int i = 0; i < s; ++i) {
            portions[i] = TrundlePath.elide(this.extract(i));
        }
        return portions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] components() {
        if (this.isRoot()) {
            throw new IllegalStateException("Cannot compute components for root");
        }
        if (this.componentIndexes != null) {
            return this.componentIndexes;
        }
        TrundlePath trundlePath = this;
        synchronized (trundlePath) {
            if (this.componentIndexes != null) {
                return this.componentIndexes;
            }
            String path = this.path;
            int components = this.isEmptyPath() ? 0 : 1;
            for (char c : path.toCharArray()) {
                if (c != '/') continue;
                ++components;
            }
            int[] array = new int[components + 1];
            int length = path.length();
            array[0] = -1;
            array[components] = length;
            int index = 1;
            for (int i = 0; i < length; ++i) {
                if (path.charAt(i) != '/') continue;
                array[index++] = i;
            }
            this.componentIndexes = array;
        }
        return this.componentIndexes;
    }

    @Override
    private int compareTo(TrundlePath other) {
        return this.path.compareTo(other.path);
    }

    private boolean isEmptyPath() {
        return this.root.isEmpty() && this.path.isEmpty();
    }

    private boolean isRoot() {
        return !this.root.isEmpty() && this.path.equals(this.root);
    }

    private String extract(int index) {
        int[] components;
        if (this.isRoot()) {
            throw new IllegalStateException("Cannot extract component of root");
        }
        if (index < 0 || index >= (components = this.components()).length - 1) {
            throw new IllegalArgumentException(Integer.toString(index));
        }
        return this.path.substring(components[index] + 1, components[index + 1]);
    }

    private TrundlePath resolve() {
        return (TrundlePath)this.toAbsolutePath();
    }

    private record ParsedPath(TrundlePathType type, String root, String path) {
    }
}

