/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleAttributes;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleDirectory;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleException;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleFile;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePath;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePathResolutionResult;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class TrundleResources {
    private TrundleResources() {
    }

    static Void access(TrundlePathResolutionResult result, AccessMode ... mode) throws IOException {
        AccessFlags flags = AccessFlags.of(mode);
        TrundleResource resource = result.element();
        if (resource == null) {
            throw new NoSuchFileException(result.elementName());
        }
        TrundlePath origin = result.originalPath();
        DosFileAttributes attributes = null;
        if (flags.write() && (attributes = origin.attributes(DosFileAttributes.class, new LinkOption[0])).isReadOnly()) {
            throw new AccessDeniedException(result.elementName(), null, "File is read only");
        }
        if (flags.execute() && !(attributes == null ? origin.attributes(DosFileAttributes.class, new LinkOption[0]) : attributes).isSystem()) {
            throw new AccessDeniedException(result.elementName(), null, "Cannot execute non-system file");
        }
        return null;
    }

    static Void directory(TrundlePathResolutionResult result, FileAttribute<?> ... attributes) {
        if (result.element() != null) {
            throw new TrundleException(TrundleException.Code.ITEM_ALREADY_EXISTS, result.elementName());
        }
        TrundleResource parent = result.parent();
        TrundleDirectory directory = new TrundleDirectory(result.elementName(), new ArrayList(Arrays.asList(attributes)));
        parent.add(directory);
        return null;
    }

    static Void delete(TrundlePathResolutionResult result) throws IOException {
        TrundleResources.delete(result, true);
        return null;
    }

    static boolean deleteIfExists(TrundlePathResolutionResult result) throws IOException {
        return TrundleResources.delete(result, false);
    }

    static Void copy(TrundlePathResolutionResult from, TrundlePathResolutionResult to, CopyOption ... options) throws IOException {
        TrundleResource copy;
        boolean destinationDirectory;
        CopyFlags flags = CopyFlags.of(options);
        TrundleResource source = from.element();
        TrundleResource maybeDestination = to.element();
        TrundleResource destinationParent = to.parent();
        if (source == null) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, "No such file " + from.elementName());
        }
        if (source == maybeDestination) {
            return null;
        }
        boolean destinationExists = maybeDestination != null;
        boolean bl = destinationDirectory = destinationExists && maybeDestination.type() == TrundleResource.Type.DIRECTORY;
        if (destinationExists && !flags.replaceExisting()) {
            throw new FileAlreadyExistsException(maybeDestination.name());
        }
        if (flags.replaceExisting() && destinationDirectory && !((TrundleDirectory)maybeDestination).children().isEmpty()) {
            throw new DirectoryNotEmptyException(maybeDestination.name());
        }
        ArrayList attributes = new ArrayList(flags.copyAttributes() ? source.attributes() : List.of());
        String name = to.elementName();
        boolean isDirectoryCopy = source.type() == TrundleResource.Type.DIRECTORY;
        TrundleResource trundleResource = copy = isDirectoryCopy ? new TrundleDirectory(name, attributes) : new TrundleFile(name, source.contents(), attributes);
        if (destinationExists) {
            destinationParent.remove(maybeDestination);
        }
        destinationParent.add(copy);
        return null;
    }

    static Void move(TrundlePathResolutionResult from, TrundlePathResolutionResult to, CopyOption ... options) throws IOException {
        boolean destinationDirectory;
        MoveFlags flags = MoveFlags.of(options);
        TrundleResource source = from.element();
        TrundleResource sourceParent = from.parent();
        TrundleResource maybeDestination = to.element();
        TrundleResource destinationParent = to.parent();
        if (source == null) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, "No such file " + from.elementName());
        }
        if (source == maybeDestination) {
            return null;
        }
        boolean destinationExists = maybeDestination != null;
        boolean bl = destinationDirectory = destinationExists && maybeDestination.type() == TrundleResource.Type.DIRECTORY;
        if (destinationExists && !flags.replaceExisting()) {
            throw new FileAlreadyExistsException(maybeDestination.name());
        }
        if (flags.replaceExisting() && destinationDirectory && !((TrundleDirectory)maybeDestination).children().isEmpty()) {
            throw new DirectoryNotEmptyException(maybeDestination.name());
        }
        if (from.originalPath().fileStore() != to.originalPath().fileStore()) {
            throw new DirectoryNotEmptyException(source.name());
        }
        if (flags.atomicMove()) {
            throw new AtomicMoveNotSupportedException(source.name(), to.elementName(), "Atomic moves are not yet implemented");
        }
        if (destinationExists) {
            destinationParent.remove(maybeDestination);
        }
        destinationParent.add(source);
        sourceParent.remove(source);
        return null;
    }

    static boolean same(TrundlePathResolutionResult a, TrundlePathResolutionResult b) throws IOException {
        TrundleResource first = a.element();
        TrundleResource second = b.element();
        if (first == null || second == null) {
            throw new IOException("Unable to check if two files are the same with at least one that does not exist", new NullPointerException());
        }
        return first == second;
    }

    static boolean hidden(TrundlePathResolutionResult path) throws IOException {
        TrundleResource resource = path.element();
        if (resource == null) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, path.elementName());
        }
        return TrundleAttributes.hidden(path);
    }

    private static boolean delete(TrundlePathResolutionResult result, boolean crash) throws IOException {
        TrundleDirectory directory;
        TrundleResource resource = result.element();
        if (resource == null) {
            if (crash) {
                throw new NoSuchFileException(result.elementName());
            }
            return false;
        }
        if (resource.type() == TrundleResource.Type.DIRECTORY && !(directory = (TrundleDirectory)resource).children().isEmpty()) {
            throw new DirectoryNotEmptyException(result.elementName());
        }
        TrundleResource parent = result.parent();
        parent.remove(resource);
        return true;
    }

    @SafeVarargs
    private static <T> Set<T> check(Set<T> allowed, T ... provided) {
        return TrundleResources.check(new HashSet<T>(Arrays.asList(provided)), allowed);
    }

    private static <T> Set<T> check(Set<T> provided, Set<T> allowed) {
        HashSet<T> difference = new HashSet<T>(provided);
        difference.removeAll(allowed);
        if (!difference.isEmpty()) {
            throw new UnsupportedOperationException("Unknown option " + difference);
        }
        return provided;
    }

    private record AccessFlags(boolean read, boolean write, boolean execute) {
        private static final Set<AccessMode> ALLOWED = Set.of(AccessMode.READ, AccessMode.EXECUTE, AccessMode.WRITE);

        static AccessFlags of(AccessMode ... modes) {
            Set<AccessMode> modeSet = TrundleResources.check(ALLOWED, modes);
            boolean read = modeSet.contains((Object)AccessMode.READ);
            boolean write = modeSet.contains((Object)AccessMode.WRITE);
            boolean execute = modeSet.contains((Object)AccessMode.EXECUTE);
            return new AccessFlags(read, write, execute);
        }
    }

    private record CopyFlags(boolean replaceExisting, boolean copyAttributes) {
        private static final Set<CopyOption> ALLOWED = Set.of(StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);

        static CopyFlags of(CopyOption ... options) {
            Set<CopyOption> optionSet = TrundleResources.check(ALLOWED, options);
            boolean replaceExisting = optionSet.contains(StandardCopyOption.REPLACE_EXISTING);
            boolean copyAttributes = optionSet.contains(StandardCopyOption.COPY_ATTRIBUTES);
            return new CopyFlags(replaceExisting, copyAttributes);
        }
    }

    private record MoveFlags(boolean replaceExisting, boolean atomicMove) {
        private static final Set<CopyOption> ALLOWED = Set.of(StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);

        static MoveFlags of(CopyOption ... options) {
            Set<CopyOption> optionSet = TrundleResources.check(ALLOWED, options);
            boolean replaceExisting = optionSet.contains(StandardCopyOption.REPLACE_EXISTING);
            boolean atomicMove = optionSet.contains(StandardCopyOption.ATOMIC_MOVE);
            return new MoveFlags(replaceExisting, atomicMove);
        }
    }
}

