/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public final class FreezableIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private final AtomicBoolean freeze;
    private final boolean ownership;

    private FreezableIterator(Iterator<T> delegate, AtomicBoolean freeze, boolean ownership) {
        this.delegate = delegate;
        this.freeze = freeze;
        this.ownership = ownership;
    }

    public static <T> FreezableIterator<T> of(Iterator<T> delegate) {
        return FreezableIterator.of(delegate, false);
    }

    public static <T> FreezableIterator<T> of(Iterator<T> delegate, boolean freeze) {
        return new FreezableIterator<T>(delegate, new AtomicBoolean(freeze), true);
    }

    static <T> FreezableIterator<T> of(Iterator<T> delegate, AtomicBoolean freeze) {
        return new FreezableIterator<T>(delegate, freeze, false);
    }

    public void freeze() {
        if (!this.ownership) {
            throw new UnsupportedOperationException("freeze: Depends on another freezable object");
        }
        this.freeze.set(true);
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return this.delegate.next();
    }

    @Override
    public void remove() {
        if (this.freeze.get()) {
            throw new UnsupportedOperationException("remove: Iterator is frozen");
        }
        this.delegate.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.delegate.forEachRemaining(action);
    }
}

