/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.util;

import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

final class FreezableListIterator<T>
implements ListIterator<T> {
    private final ListIterator<T> delegate;
    private final AtomicBoolean freeze;
    private final boolean ownership;

    private FreezableListIterator(ListIterator<T> delegate, AtomicBoolean freeze, boolean ownership) {
        this.delegate = delegate;
        this.freeze = freeze;
        this.ownership = ownership;
    }

    public static <T> FreezableListIterator<T> of(ListIterator<T> delegate) {
        return FreezableListIterator.of(delegate, false);
    }

    public static <T> FreezableListIterator<T> of(ListIterator<T> delegate, boolean frozen) {
        return new FreezableListIterator<T>(delegate, new AtomicBoolean(frozen), true);
    }

    static <T> FreezableListIterator<T> of(ListIterator<T> delegate, AtomicBoolean frozen) {
        return new FreezableListIterator<T>(delegate, frozen, false);
    }

    public void freeze() {
        if (!this.ownership) {
            throw new UnsupportedOperationException("freeze: Depends on another freezable object");
        }
        this.freeze.set(true);
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return this.delegate.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    @Override
    public T previous() {
        return this.delegate.previous();
    }

    @Override
    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    @Override
    public void remove() {
        if (this.freeze.get()) {
            throw new UnsupportedOperationException("remove: ListIterator is frozen");
        }
        this.delegate.remove();
    }

    @Override
    public void set(T t) {
        if (this.freeze.get()) {
            throw new UnsupportedOperationException("set: ListIterator is frozen");
        }
        this.delegate.set(t);
    }

    @Override
    public void add(T t) {
        if (this.freeze.get()) {
            throw new UnsupportedOperationException("add: ListIterator is frozen");
        }
        this.delegate.add(t);
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.delegate.forEachRemaining(action);
    }
}

