/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.zen.bracket;

import com.blamejared.contenttweaker.core.api.zen.bracket.BracketHelper;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedExpression;

final class ResourceLocationBracketExpressionParser
implements BracketExpressionParser {
    ResourceLocationBracketExpressionParser() {
    }

    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        String contents = ParseUtil.readBracketContent((CodePosition)position, (ZSTokenParser)tokens);
        if (contents.indexOf(58) == -1) {
            throw new IllegalStateException("Expected resource bracket in the format <resource:modid:path>, but found <resource:%s>".formatted(contents));
        }
        String[] split = contents.split(Pattern.quote(":"), 2);
        return new ResourceLocationExpression(position, split[0], split[1]);
    }

    private static final class ResourceLocationExpression
    extends ParsedExpression {
        private final String location;

        ResourceLocationExpression(CodePosition position, String namespace, String path) {
            super(position);
            this.location = "%s:%s".formatted(Objects.requireNonNull(namespace), Objects.requireNonNull(path));
        }

        public IPartialExpression compile(ExpressionScope scope) throws CompileException {
            ResourceLocation location = BracketHelper.parseToCompile(this.position, () -> BracketHelper.locationOrThrow(this.position, this.location));
            return BracketHelper.locationArgument(this.position, location).compile(scope);
        }

        public boolean hasStrongType() {
            return true;
        }
    }
}

