/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.forge.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.TierSortingRegistry;

public final class TierRegistry
implements GameRegistry<Tier> {
    private final Map<ResourceLocation, Supplier<Tier>> commands = new HashMap<ResourceLocation, Supplier<Tier>>();

    private TierRegistry() {
    }

    public static TierRegistry of() {
        return new TierRegistry();
    }

    @Override
    public ObjectType<Tier> type() {
        return VanillaObjectTypes.TIER;
    }

    @Override
    public Tier get(ResourceLocation name) {
        this.flushCommands();
        return TierSortingRegistry.byName((ResourceLocation)Objects.requireNonNull(name));
    }

    @Override
    public ResourceLocation nameOf(Tier object) {
        this.flushCommands();
        return TierSortingRegistry.getName((Tier)Objects.requireNonNull(object));
    }

    @Override
    public Collection<Tier> all() {
        this.flushCommands();
        return TierSortingRegistry.getSortedTiers();
    }

    @Override
    public void enqueueRegistration(ResourceLocation name, Supplier<Tier> objectCreator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(objectCreator);
        if (this.commands.containsKey(name)) {
            throw new IllegalStateException("A tier with the name '" + name + "' was already registered");
        }
        this.commands.put(name, objectCreator);
    }

    private void flushCommands() {
        if (this.commands.isEmpty()) {
            return;
        }
        this.commands.forEach((name, value) -> value.get());
        this.commands.clear();
    }
}

