/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.forge.api.zen.factory;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.action.RegisterObjectAction;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.forge.api.zen.rt.TierSortingStruct;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.resource.Tag;
import com.blamejared.contenttweaker.vanilla.api.zen.factory.TierFactory;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.TierReference;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.NameUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.TierSortingRegistry;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Expansion(value="contenttweaker.factory.vanilla.TierFactory")
@ZenRegister(loaders={"contenttweaker"})
public final class ForgeTierFactoryExpansions {
    private ForgeTierFactoryExpansions() {
    }

    @ZenCodeType.Method(value="create")
    public static TierReference of(TierFactory $this, String name, int level, int uses, float speed, float attackDamageBonus, int enchantmentValue, ResourceLocation tag, ItemReference repairItem, @ZenCodeType.Optional(value="[] as contenttweaker._rt.vanilla.TierSortingStruct[]") TierSortingStruct[] lowerTiers, @ZenCodeType.Optional(value="[] as contenttweaker._rt.vanilla.TierSortingStruct[]") TierSortingStruct[] higherTiers) {
        ResourceLocation tierName = ContentTweakerConstants.rl(NameUtil.fixing((String)name, (fixed, mistakes) -> ForgeTierFactoryExpansions.report(name, fixed, mistakes)));
        if (level < 0) {
            throw new IllegalArgumentException("Level for tier " + tierName + " cannot be negative");
        }
        if (uses <= 0) {
            throw new IllegalArgumentException("Uses for tier " + tierName + " cannot be negative or zero");
        }
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tag);
        ObjectHolder<Tier> holder = ObjectHolder.of(VanillaObjectTypes.TIER, tierName, () -> {
            ForgeTier forgeTier = new ForgeTier(level, uses, speed, attackDamageBonus, enchantmentValue, tagKey, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)repairItem.get()}));
            List<Object> resolvedLowerTiers = Arrays.stream(lowerTiers).map(TierSortingStruct::get).map(Supplier::get).toList();
            List<Object> resolverHigherTiers = Arrays.stream(higherTiers).map(TierSortingStruct::get).map(Supplier::get).toList();
            return TierSortingRegistry.registerTier((Tier)forgeTier, (ResourceLocation)tierName, resolvedLowerTiers, resolverHigherTiers);
        });
        ContentTweakerApi.apply(RegisterObjectAction.of(holder, manager -> {
            ResourceFragment data = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_DATA);
            data.provideOrAlter(PathHelper.tag(VanillaObjectTypes.BLOCK, tag), Tag::of, Function.identity(), Tag.SERIALIZER);
        }));
        return TierReference.of(tierName);
    }

    private static void report(String original, String fixed, List<String> mistakes) {
        CraftTweakerAPI.LOGGER.warn(() -> "The given name '%s' is not valid: it has been fixed to '%s'.\nMistakes:%s".formatted(original, fixed, String.join((CharSequence)"\n", mistakes)));
    }
}

