/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.forge.api.zen.rt;

import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.TierReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker._rt.vanilla.TierSortingStruct")
@ZenRegister(loaders={"contenttweaker"})
public final class TierSortingStruct {
    private final ResourceLocation rl;
    private final String name;
    private final TierReference tier;

    private TierSortingStruct(ResourceLocation rl, String name, TierReference tier) {
        this.rl = rl;
        this.name = name;
        this.tier = tier;
    }

    static TierSortingStruct of(ResourceLocation rl) {
        return new TierSortingStruct(Objects.requireNonNull(rl), null, null);
    }

    static TierSortingStruct of(String name) {
        return new TierSortingStruct(null, Objects.requireNonNull(name), null);
    }

    static TierSortingStruct of(TierReference tier) {
        return new TierSortingStruct(null, null, Objects.requireNonNull(tier));
    }

    public Supplier<Object> get() {
        return () -> Stream.of(this.rl, this.name, Optional.ofNullable(this.tier).map(Reference::get).orElse(null)).filter(Objects::nonNull).findFirst().orElseGet(Object::new);
    }

    @ZenCodeType.Expansion(value="string")
    @ZenRegister(loaders={"contenttweaker"})
    public static final class StringCaster {
        private StringCaster() {
        }

        @ZenCodeType.Caster(implicit=true)
        public static TierSortingStruct asTierSortingStruct(String $this) {
            return TierSortingStruct.of($this);
        }
    }

    @ZenCodeType.Expansion(value="contenttweaker.object.vanilla.TierReference")
    @ZenRegister(loaders={"contenttweaker"})
    public static final class TierCaster {
        private TierCaster() {
        }

        @ZenCodeType.Caster(implicit=true)
        public static TierSortingStruct asTierSortingStruct(TierReference $this) {
            return TierSortingStruct.of($this);
        }
    }

    @ZenCodeType.Expansion(value="contenttweaker.resource.ResourceLocation")
    @ZenRegister(loaders={"contenttweaker"})
    public static final class ResourceLocationCaster {
        private ResourceLocationCaster() {
        }

        @ZenCodeType.Caster(implicit=true)
        public static TierSortingStruct asTierSortingStruct(ResourceLocation $this) {
            return TierSortingStruct.of($this);
        }
    }
}

