/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.forge.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.forge.registry.DeferredGameRegistry;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ForgeGameRegistry<T extends IForgeRegistryEntry<T>>
implements DeferredGameRegistry<T> {
    private static final Map<ObjectType<?>, ForgeGameRegistry<?>> INSTANCES = new HashMap();
    private static final Supplier<ModContainer> COT_CONTAINER = Suppliers.memoize(() -> (ModContainer)ModList.get().getModContainerById("contenttweaker").orElseThrow());
    private final ObjectType<T> type;
    private final ForgeRegistry<T> forgeRegistry;
    private final List<Runnable> commands;

    private ForgeGameRegistry(ObjectType<T> type, ForgeRegistry<T> registry) {
        this.type = type;
        this.forgeRegistry = registry;
        this.commands = new ArrayList<Runnable>();
    }

    static <T extends IForgeRegistryEntry<T>> ForgeGameRegistry<T> of(ObjectType<T> type, ForgeRegistry<T> registry) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(registry, "registry");
        if (registry.getRegistrySuperType() != type.type()) {
            throw new IllegalArgumentException("Mismatched types between registry (" + registry.getRegistrySuperType().getName() + ") and type (" + type.type().getName() + ")");
        }
        return (ForgeGameRegistry)GenericUtil.uncheck((Object)INSTANCES.computeIfAbsent(type, it -> new ForgeGameRegistry(type, registry)));
    }

    @Override
    public ObjectType<T> type() {
        return this.type;
    }

    @Override
    public T get(ResourceLocation name) {
        return (T)this.forgeRegistry.getValue(Objects.requireNonNull(name));
    }

    @Override
    public ResourceLocation nameOf(T object) {
        return ((IForgeRegistryEntry)Objects.requireNonNull(object)).getRegistryName();
    }

    @Override
    public void enqueueRegistration(ResourceLocation name, Supplier<T> object) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(object, "object");
        this.commands.add(() -> this.forgeRegistry.register((IForgeRegistryEntry)Objects.requireNonNull((IForgeRegistryEntry)object.get(), "get").setRegistryName(name)));
    }

    @Override
    public Collection<T> all() {
        return this.forgeRegistry.getValues();
    }

    @Override
    public List<Runnable> commands() {
        return this.commands;
    }

    @Override
    public void doRegistration() {
        this.withContainer(() -> DeferredGameRegistry.super.doRegistration());
    }

    private void withContainer(Runnable runnable) {
        ModContainer activeContainer = ModLoadingContext.get().getActiveContainer();
        ModLoadingContext.get().setActiveContainer(COT_CONTAINER.get());
        runnable.run();
        ModLoadingContext.get().setActiveContainer(activeContainer);
    }

    public String toString() {
        return "%s[%s]{%s}".formatted(this.forgeRegistry.getRegistryName(), this.type, this.forgeRegistry);
    }
}

