/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.forge.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.forge.registry.DeferredGameRegistry;
import com.blamejared.contenttweaker.forge.registry.ForgeGameRegistry;
import com.blamejared.contenttweaker.forge.registry.VanillaGameRegistry;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public final class GameRegistryFactory {
    private static final Map<ObjectType<?>, DeferredGameRegistry<?>> REGISTRY_CACHE = new HashMap();

    private GameRegistryFactory() {
    }

    public static <T, U> DeferredGameRegistry<T> findRegistryFromTypeAlone(ObjectType<T> type) {
        Objects.requireNonNull(type);
        return (DeferredGameRegistry)GenericUtil.uncheck((Object)REGISTRY_CACHE.computeIfAbsent(type, it -> GameRegistryFactory.findRegistry(type, type.key())));
    }

    public static <T> DeferredGameRegistry<T> findRegistryFromKey(ObjectType<T> type, ResourceKey<? extends Registry<T>> key) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(key);
        return (DeferredGameRegistry)GenericUtil.uncheck((Object)REGISTRY_CACHE.computeIfAbsent(type, it -> GameRegistryFactory.findRegistry(type, key)));
    }

    private static <T> DeferredGameRegistry<T> findRegistry(ObjectType<T> type, ResourceKey<? extends Registry<T>> key) {
        ResourceLocation registryId = Objects.requireNonNull(key).m_135782_();
        return Objects.requireNonNullElseGet(GameRegistryFactory.findForgeRegistry(type, registryId), () -> GameRegistryFactory.findVanillaRegistry(type, registryId));
    }

    private static <T, U extends IForgeRegistryEntry<U>> DeferredGameRegistry<T> findForgeRegistry(ObjectType<T> type, ResourceLocation registryId) {
        if (!IForgeRegistryEntry.class.isAssignableFrom(type.type())) {
            return null;
        }
        DeferredGameRegistry<T> captured = GameRegistryFactory.findForgeRegistryCapturing((ObjectType)GenericUtil.uncheck(type), registryId);
        return captured == null ? null : (DeferredGameRegistry)GenericUtil.uncheck(captured);
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredGameRegistry<T> findForgeRegistryCapturing(ObjectType<T> type, ResourceLocation registryId) {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryId);
        if (registry == null) {
            return null;
        }
        return ForgeGameRegistry.of(type, registry);
    }

    private static <T> DeferredGameRegistry<T> findVanillaRegistry(ObjectType<T> type, ResourceLocation registryId) {
        Registry registry = (Registry)GenericUtil.uncheck((Object)Registry.f_122897_.m_7745_(registryId));
        return VanillaGameRegistry.of(type, registry);
    }
}

