/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.forge.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.forge.registry.DeferredGameRegistry;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryManager;

public final class VanillaGameRegistry<T>
implements DeferredGameRegistry<T> {
    private static final Map<ObjectType<?>, VanillaGameRegistry<?>> INSTANCES = new HashMap();
    private final Registry<T> registry;
    private final ObjectType<T> type;
    private final List<Runnable> commands;

    private VanillaGameRegistry(Registry<T> registry, ObjectType<T> type) {
        this.registry = registry;
        this.type = type;
        this.commands = new ArrayList<Runnable>();
    }

    static <T> VanillaGameRegistry<T> of(ObjectType<T> type, Registry<T> registry) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(type, "type");
        if (RegistryManager.ACTIVE.getRegistry(registry.m_123023_().m_135782_()) != null) {
            throw new IllegalArgumentException("Registry " + registry.m_123023_().m_135782_() + " is slave to a Forge Registry");
        }
        return (VanillaGameRegistry)GenericUtil.uncheck((Object)INSTANCES.computeIfAbsent(type, it -> new VanillaGameRegistry(registry, type)));
    }

    @Override
    public ObjectType<T> type() {
        return this.type;
    }

    @Override
    public T get(ResourceLocation name) {
        return (T)this.registry.m_7745_(Objects.requireNonNull(name));
    }

    @Override
    public ResourceLocation nameOf(T object) {
        return this.registry.m_7981_(Objects.requireNonNull(object));
    }

    @Override
    public Collection<T> all() {
        return this.stream().toList();
    }

    @Override
    public void enqueueRegistration(ResourceLocation name, Supplier<T> object) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(object, "object");
        this.commands.add(() -> Registry.m_122965_(this.registry, (ResourceLocation)name, Objects.requireNonNull(object.get(), "get")));
    }

    @Override
    public Stream<T> stream() {
        return this.registry.m_123024_();
    }

    @Override
    public List<Runnable> commands() {
        return this.commands;
    }

    public String toString() {
        return "%s[%s]{%s}".formatted(this.registry.m_123023_().m_135782_(), this.type, this.registry);
    }
}

