/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.forge.resource;

import com.blamejared.contenttweaker.core.resource.RuntimeRepositorySource;
import com.blamejared.contenttweaker.core.resource.UserRepositorySource;
import java.util.function.Function;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public final class ForgeResourceManager {
    private ForgeResourceManager() {
    }

    public static void init(IEventBus modBus) {
        modBus.addListener(EventPriority.HIGH, false, AddPackFindersEvent.class, ForgeResourceManager::injectRuntime);
        modBus.addListener(EventPriority.LOW, false, AddPackFindersEvent.class, ForgeResourceManager::injectUser);
    }

    private static void injectRuntime(AddPackFindersEvent event) {
        ForgeResourceManager.injectSource(event, RuntimeRepositorySource::of);
    }

    private static void injectUser(AddPackFindersEvent event) {
        ForgeResourceManager.injectSource(event, UserRepositorySource::of);
    }

    private static void injectSource(AddPackFindersEvent event, Function<PackType, ? extends RepositorySource> constructor) {
        event.addRepositorySource(constructor.apply(event.getPackType()));
    }
}

