/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.ContentTweakerVanillaApi;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;

public final class CreativeTabRegistry
implements GameRegistry<CreativeModeTab> {
    private final Map<ResourceLocation, CreativeModeTab> fastLookup = new HashMap<ResourceLocation, CreativeModeTab>();
    private final Map<String, Supplier<CreativeModeTab>> creators = new HashMap<String, Supplier<CreativeModeTab>>();

    private CreativeTabRegistry() {
    }

    public static CreativeTabRegistry of() {
        return new CreativeTabRegistry();
    }

    public static ResourceLocation fromId(String name) {
        return new ResourceLocation(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, Objects.requireNonNull(name)));
    }

    public static String toId(ResourceLocation name) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, Objects.requireNonNull(name).m_135815_());
    }

    @Override
    public ObjectType<CreativeModeTab> type() {
        return VanillaObjectTypes.CREATIVE_TAB;
    }

    @Override
    public CreativeModeTab get(ResourceLocation name) {
        if (this.fastLookup.containsKey(name)) {
            return this.fastLookup.get(name);
        }
        String id = CreativeTabRegistry.toId(name);
        if (this.creators.containsKey(id)) {
            this.register(this.creators.get(id));
            this.creators.remove(id);
        }
        CreativeModeTab tab = Arrays.stream(CreativeModeTab.f_40748_).filter(it -> id.equals(ContentTweakerVanillaApi.get().creativeTabId((CreativeModeTab)it))).findFirst().orElse(null);
        this.fastLookup.put(name, tab);
        return tab;
    }

    @Override
    public ResourceLocation nameOf(CreativeModeTab object) {
        return CreativeTabRegistry.fromId(ContentTweakerVanillaApi.get().creativeTabId(Objects.requireNonNull(object)));
    }

    @Override
    public Collection<CreativeModeTab> all() {
        return Arrays.asList(CreativeModeTab.f_40748_);
    }

    @Override
    public void enqueueRegistration(ResourceLocation name, Supplier<CreativeModeTab> objectCreator) {
        String id = CreativeTabRegistry.toId(name);
        if (this.creators.containsKey(id)) {
            throw new IllegalStateException("Already registered a creative tab for id '" + id + "'");
        }
        this.creators.put(id, objectCreator);
    }

    private void register(Supplier<CreativeModeTab> tab) {
        this.expandByOne();
        tab.get();
    }

    private void expandByOne() {
        CreativeModeTab[] tabs = CreativeModeTab.f_40748_;
        int length = tabs.length;
        CreativeModeTab[] newTabs = new CreativeModeTab[length + 1];
        System.arraycopy(tabs, 0, newTabs, 0, length);
        newTabs[length] = null;
        ContentTweakerVanillaApi.get().creativeTabs(newTabs);
    }
}

