/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Material;

public final class MaterialRegistry
implements GameRegistry<Material> {
    private final BiMap<ResourceLocation, Material> materials = HashBiMap.create();
    private final BiMap<Material, ResourceLocation> inverse = this.materials.inverse();
    private final Consumer<BiMap<ResourceLocation, Material>> vanillaGatherer = map -> map.putAll((Map)vanillaMaterialsGetter.get());
    private final Map<ResourceLocation, Supplier<Material>> commands = new HashMap<ResourceLocation, Supplier<Material>>();

    private MaterialRegistry(Supplier<Map<ResourceLocation, Material>> vanillaMaterialsGetter) {
    }

    public static MaterialRegistry of() {
        return new MaterialRegistry(MaterialRegistry::computeVanillaMaterials);
    }

    private static Map<ResourceLocation, Material> computeVanillaMaterials() {
        HashMap<ResourceLocation, Material> map = new HashMap<ResourceLocation, Material>();
        MaterialRegistry.entry(map, "air", Material.f_76296_);
        MaterialRegistry.entry(map, "structural_air", Material.f_76297_);
        MaterialRegistry.entry(map, "portal", Material.f_76298_);
        MaterialRegistry.entry(map, "cloth_decoration", Material.f_76299_);
        MaterialRegistry.entry(map, "plant", Material.f_76300_);
        MaterialRegistry.entry(map, "water_plant", Material.f_76301_);
        MaterialRegistry.entry(map, "replaceable_plant", Material.f_76302_);
        MaterialRegistry.entry(map, "replaceable_fireproof_plant", Material.f_76303_);
        MaterialRegistry.entry(map, "replaceable_water_plant", Material.f_76304_);
        MaterialRegistry.entry(map, "water", Material.f_76305_);
        MaterialRegistry.entry(map, "bubble_column", Material.f_76306_);
        MaterialRegistry.entry(map, "lava", Material.f_76307_);
        MaterialRegistry.entry(map, "top_snow", Material.f_76308_);
        MaterialRegistry.entry(map, "fire", Material.f_76309_);
        MaterialRegistry.entry(map, "decoration", Material.f_76310_);
        MaterialRegistry.entry(map, "web", Material.f_76311_);
        MaterialRegistry.entry(map, "sculk", Material.f_164533_);
        MaterialRegistry.entry(map, "buildable_glass", Material.f_76312_);
        MaterialRegistry.entry(map, "clay", Material.f_76313_);
        MaterialRegistry.entry(map, "dirt", Material.f_76314_);
        MaterialRegistry.entry(map, "grass", Material.f_76315_);
        MaterialRegistry.entry(map, "ice_solid", Material.f_76316_);
        MaterialRegistry.entry(map, "sand", Material.f_76317_);
        MaterialRegistry.entry(map, "sponge", Material.f_76318_);
        MaterialRegistry.entry(map, "shulker_shell", Material.f_76319_);
        MaterialRegistry.entry(map, "wood", Material.f_76320_);
        MaterialRegistry.entry(map, "nether_wood", Material.f_76321_);
        MaterialRegistry.entry(map, "bamboo_sapling", Material.f_76270_);
        MaterialRegistry.entry(map, "bamboo", Material.f_76271_);
        MaterialRegistry.entry(map, "wool", Material.f_76272_);
        MaterialRegistry.entry(map, "explosive", Material.f_76273_);
        MaterialRegistry.entry(map, "leaves", Material.f_76274_);
        MaterialRegistry.entry(map, "glass", Material.f_76275_);
        MaterialRegistry.entry(map, "ice", Material.f_76276_);
        MaterialRegistry.entry(map, "cactus", Material.f_76277_);
        MaterialRegistry.entry(map, "stone", Material.f_76278_);
        MaterialRegistry.entry(map, "metal", Material.f_76279_);
        MaterialRegistry.entry(map, "snow", Material.f_76280_);
        MaterialRegistry.entry(map, "heavy_metal", Material.f_76281_);
        MaterialRegistry.entry(map, "barrier", Material.f_76282_);
        MaterialRegistry.entry(map, "piston", Material.f_76283_);
        MaterialRegistry.entry(map, "moss", Material.f_164530_);
        MaterialRegistry.entry(map, "vegetable", Material.f_76285_);
        MaterialRegistry.entry(map, "egg", Material.f_76286_);
        MaterialRegistry.entry(map, "cake", Material.f_76287_);
        MaterialRegistry.entry(map, "amethyst", Material.f_164531_);
        MaterialRegistry.entry(map, "powder_snow", Material.f_164532_);
        return map;
    }

    private static void entry(Map<ResourceLocation, Material> map, String name, Material material) {
        map.put(new ResourceLocation(name.toLowerCase(Locale.ENGLISH)), material);
    }

    @Override
    public ObjectType<Material> type() {
        return VanillaObjectTypes.MATERIAL;
    }

    @Override
    public Material get(ResourceLocation name) {
        this.populateMap();
        if (this.commands.containsKey(name)) {
            return this.register(name, this.commands.get(name));
        }
        return (Material)this.materials.get((Object)name);
    }

    @Override
    public ResourceLocation nameOf(Material material) {
        this.populateMap();
        return (ResourceLocation)this.inverse.computeIfAbsent((Object)material, it -> {
            throw new IllegalArgumentException("No such material " + it + " known: it is probably not registered");
        });
    }

    @Override
    public Collection<Material> all() {
        this.populateMap();
        return this.materials.values();
    }

    @Override
    public void enqueueRegistration(ResourceLocation name, Supplier<Material> objectCreator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(objectCreator);
        if (this.commands.containsKey(name)) {
            throw new IllegalArgumentException("A material with name '" + name + "' was already enqueued for registration");
        }
        this.commands.put(name, objectCreator);
    }

    public Material register(ResourceLocation name, Supplier<Material> creator) {
        Objects.requireNonNull(creator);
        if (this.materials.containsKey((Object)Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("A material with name " + name + " is already known");
        }
        Material material = Objects.requireNonNull(creator.get());
        this.materials.put((Object)name, (Object)material);
        this.commands.remove(name);
        return material;
    }

    private void populateMap() {
        if (this.materials.isEmpty()) {
            this.vanillaGatherer.accept(this.materials);
        }
    }
}

