/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;

public final class SoundTypeRegistry
implements GameRegistry<SoundType> {
    private final BiMap<ResourceLocation, SoundType> soundTypes = HashBiMap.create();
    private final BiMap<SoundType, ResourceLocation> inverse = this.soundTypes.inverse();
    private final Consumer<BiMap<ResourceLocation, SoundType>> vanillaProvider = map -> map.putAll((Map)vanillaComputer.get());
    private final Map<ResourceLocation, Supplier<SoundType>> commands = new HashMap<ResourceLocation, Supplier<SoundType>>();

    private SoundTypeRegistry(Supplier<Map<ResourceLocation, SoundType>> vanillaComputer) {
    }

    public static SoundTypeRegistry of() {
        return new SoundTypeRegistry(SoundTypeRegistry::gatherVanilla);
    }

    private static Map<ResourceLocation, SoundType> gatherVanilla() {
        HashMap<ResourceLocation, SoundType> map = new HashMap<ResourceLocation, SoundType>();
        SoundTypeRegistry.entry(map, "wood", SoundType.f_56736_);
        SoundTypeRegistry.entry(map, "gravel", SoundType.f_56739_);
        SoundTypeRegistry.entry(map, "grass", SoundType.f_56740_);
        SoundTypeRegistry.entry(map, "lily_pad", SoundType.f_56741_);
        SoundTypeRegistry.entry(map, "stone", SoundType.f_56742_);
        SoundTypeRegistry.entry(map, "metal", SoundType.f_56743_);
        SoundTypeRegistry.entry(map, "glass", SoundType.f_56744_);
        SoundTypeRegistry.entry(map, "wool", SoundType.f_56745_);
        SoundTypeRegistry.entry(map, "sand", SoundType.f_56746_);
        SoundTypeRegistry.entry(map, "snow", SoundType.f_56747_);
        SoundTypeRegistry.entry(map, "powder_snow", SoundType.f_154681_);
        SoundTypeRegistry.entry(map, "ladder", SoundType.f_56748_);
        SoundTypeRegistry.entry(map, "anvil", SoundType.f_56749_);
        SoundTypeRegistry.entry(map, "slime_block", SoundType.f_56750_);
        SoundTypeRegistry.entry(map, "honey_block", SoundType.f_56751_);
        SoundTypeRegistry.entry(map, "wet_grass", SoundType.f_56752_);
        SoundTypeRegistry.entry(map, "coral_block", SoundType.f_56753_);
        SoundTypeRegistry.entry(map, "bamboo", SoundType.f_56754_);
        SoundTypeRegistry.entry(map, "bamboo_sapling", SoundType.f_56755_);
        SoundTypeRegistry.entry(map, "scaffolding", SoundType.f_56756_);
        SoundTypeRegistry.entry(map, "sweet_berry_bush", SoundType.f_56757_);
        SoundTypeRegistry.entry(map, "crop", SoundType.f_56758_);
        SoundTypeRegistry.entry(map, "hard_crop", SoundType.f_56759_);
        SoundTypeRegistry.entry(map, "vine", SoundType.f_56760_);
        SoundTypeRegistry.entry(map, "nether_wart", SoundType.f_56761_);
        SoundTypeRegistry.entry(map, "lantern", SoundType.f_56762_);
        SoundTypeRegistry.entry(map, "stem", SoundType.f_56763_);
        SoundTypeRegistry.entry(map, "nylium", SoundType.f_56710_);
        SoundTypeRegistry.entry(map, "fungus", SoundType.f_56711_);
        SoundTypeRegistry.entry(map, "roots", SoundType.f_56712_);
        SoundTypeRegistry.entry(map, "shroomlight", SoundType.f_56713_);
        SoundTypeRegistry.entry(map, "weeping_vines", SoundType.f_56714_);
        SoundTypeRegistry.entry(map, "twisting_vines", SoundType.f_56715_);
        SoundTypeRegistry.entry(map, "soul_sand", SoundType.f_56716_);
        SoundTypeRegistry.entry(map, "soul_soil", SoundType.f_56717_);
        SoundTypeRegistry.entry(map, "basalt", SoundType.f_56718_);
        SoundTypeRegistry.entry(map, "wart_block", SoundType.f_56719_);
        SoundTypeRegistry.entry(map, "netherrack", SoundType.f_56720_);
        SoundTypeRegistry.entry(map, "nether_bricks", SoundType.f_56721_);
        SoundTypeRegistry.entry(map, "nether_sprouts", SoundType.f_56722_);
        SoundTypeRegistry.entry(map, "nether_ore", SoundType.f_56723_);
        SoundTypeRegistry.entry(map, "bone_block", SoundType.f_56724_);
        SoundTypeRegistry.entry(map, "netherite_block", SoundType.f_56725_);
        SoundTypeRegistry.entry(map, "ancient_debris", SoundType.f_56726_);
        SoundTypeRegistry.entry(map, "lodestone", SoundType.f_56727_);
        SoundTypeRegistry.entry(map, "chain", SoundType.f_56728_);
        SoundTypeRegistry.entry(map, "nether_gold_ore", SoundType.f_56729_);
        SoundTypeRegistry.entry(map, "gilded_blackstone", SoundType.f_56730_);
        SoundTypeRegistry.entry(map, "candle", SoundType.f_154653_);
        SoundTypeRegistry.entry(map, "amethyst", SoundType.f_154654_);
        SoundTypeRegistry.entry(map, "amethyst_cluster", SoundType.f_154655_);
        SoundTypeRegistry.entry(map, "small_amethyst_bud", SoundType.f_154656_);
        SoundTypeRegistry.entry(map, "medium_amethyst_bud", SoundType.f_154657_);
        SoundTypeRegistry.entry(map, "large_amethyst_bud", SoundType.f_154658_);
        SoundTypeRegistry.entry(map, "tuff", SoundType.f_154659_);
        SoundTypeRegistry.entry(map, "calcite", SoundType.f_154660_);
        SoundTypeRegistry.entry(map, "dripstone_block", SoundType.f_154661_);
        SoundTypeRegistry.entry(map, "pointed_dripstone", SoundType.f_154662_);
        SoundTypeRegistry.entry(map, "copper", SoundType.f_154663_);
        SoundTypeRegistry.entry(map, "cave_vines", SoundType.f_154664_);
        SoundTypeRegistry.entry(map, "spore_blossom", SoundType.f_154665_);
        SoundTypeRegistry.entry(map, "azalea", SoundType.f_154666_);
        SoundTypeRegistry.entry(map, "flowering_azalea", SoundType.f_154667_);
        SoundTypeRegistry.entry(map, "moss_carpet", SoundType.f_154668_);
        SoundTypeRegistry.entry(map, "moss", SoundType.f_154669_);
        SoundTypeRegistry.entry(map, "big_dripleaf", SoundType.f_154670_);
        SoundTypeRegistry.entry(map, "small_dripleaf", SoundType.f_154671_);
        SoundTypeRegistry.entry(map, "rooted_dirt", SoundType.f_154672_);
        SoundTypeRegistry.entry(map, "hanging_roots", SoundType.f_154673_);
        SoundTypeRegistry.entry(map, "azalea_leaves", SoundType.f_154674_);
        SoundTypeRegistry.entry(map, "sculk_sensor", SoundType.f_154675_);
        SoundTypeRegistry.entry(map, "glow_lichen", SoundType.f_154676_);
        SoundTypeRegistry.entry(map, "deepslate", SoundType.f_154677_);
        SoundTypeRegistry.entry(map, "deepslate_bricks", SoundType.f_154678_);
        SoundTypeRegistry.entry(map, "deepslate_tiles", SoundType.f_154679_);
        SoundTypeRegistry.entry(map, "polished_deepslate", SoundType.f_154680_);
        return map;
    }

    private static void entry(Map<ResourceLocation, SoundType> map, String name, SoundType type) {
        map.put(new ResourceLocation(name.toLowerCase(Locale.ENGLISH)), type);
    }

    @Override
    public ObjectType<SoundType> type() {
        return VanillaObjectTypes.SOUND_TYPE;
    }

    @Override
    public SoundType get(ResourceLocation name) {
        this.populateMap();
        if (this.commands.containsKey(name)) {
            return this.register(name, this.commands.get(name));
        }
        return (SoundType)this.soundTypes.get((Object)name);
    }

    @Override
    public ResourceLocation nameOf(SoundType type) {
        this.populateMap();
        return (ResourceLocation)this.inverse.computeIfAbsent((Object)type, it -> {
            throw new IllegalArgumentException("No such sound type " + it + " known: it is probably not registered");
        });
    }

    @Override
    public Collection<SoundType> all() {
        this.populateMap();
        return this.soundTypes.values();
    }

    @Override
    public void enqueueRegistration(ResourceLocation name, Supplier<SoundType> objectCreator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(objectCreator);
        if (this.commands.containsKey(name)) {
            throw new IllegalArgumentException("A sound type with name '" + name + "' was already enqueued for registration");
        }
        this.commands.put(name, objectCreator);
    }

    private void populateMap() {
        if (this.soundTypes.isEmpty()) {
            this.vanillaProvider.accept(this.soundTypes);
        }
    }

    public SoundType register(ResourceLocation name, Supplier<SoundType> creator) {
        Objects.requireNonNull(creator);
        if (this.soundTypes.containsKey((Object)Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("A sound type with name '" + name + "' is already known");
        }
        SoundType material = Objects.requireNonNull(creator.get());
        this.soundTypes.put((Object)name, (Object)material);
        this.commands.remove(name);
        return material;
    }
}

