/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public final class BlockState {
    public static final ResourceSerializer<BlockState> SERIALIZER = BlockState::serialize;
    private VariantOrMultipart state = null;

    private BlockState() {
    }

    public static VariantModelBuilder variant() {
        return new VariantModelBuilder(new BlockState(), BlockState::checkModel);
    }

    public static MultipartModelBuilder multipart() {
        return new MultipartModelBuilder(new BlockState(), BlockState::checkModel);
    }

    private static void checkModel(ResourceLocation name, int x, int y, boolean uvLock) {
        Objects.requireNonNull(name);
        if (x % 90 != 0 || y % 90 != 0) {
            throw new IllegalStateException("Invalid angles specified (%d,%d): must be a multiple of 90".formatted(x, y));
        }
    }

    BlockState variant(VariantModel data) {
        this.state = new VariantOrMultipart(data, null);
        return this;
    }

    BlockState multipart(MultipartModel data) {
        this.state = new VariantOrMultipart(null, data);
        return this;
    }

    private byte[] serialize() {
        return StandardResourceSerializers.JSON.serialize((JsonElement)this.state.serialize());
    }

    private record VariantOrMultipart(VariantModel variant, MultipartModel multipart) {
        JsonElement serialize() {
            return this.variant() != null ? this.variant().serialize() : this.multipart().serialize();
        }
    }

    public static final class VariantModelBuilder {
        private final BlockState parent;
        private final ModelVerifier verifier;
        private final Map<String, VariantModel.VariantData> variants;

        VariantModelBuilder(BlockState parent, ModelVerifier verifier) {
            this.parent = parent;
            this.verifier = verifier;
            this.variants = new LinkedHashMap<String, VariantModel.VariantData>();
        }

        public VariantModelBuilder singleModelFor(String variant, ResourceLocation name) {
            return this.singleModelFor(variant, name, 0, 0);
        }

        public VariantModelBuilder singleModelFor(String variant, ResourceLocation name, int x, int y) {
            return this.singleModelFor(variant, name, x, y, false);
        }

        public VariantModelBuilder singleModelFor(String variant, ResourceLocation name, int x, int y, boolean uvLock) {
            this.checkVariant(variant);
            this.verifier.checkModel(name, x, y, uvLock);
            this.variants.put(variant, new VariantModel.VariantData(new SingleOrWeightedData(new ModelData(name, x, y, uvLock), null)));
            return this;
        }

        public WeightedModelBuilder<VariantModelBuilder, ParentAdapter> weightedModelFor(String variant) {
            this.checkVariant(variant);
            return new WeightedModelBuilder<VariantModelBuilder, ParentAdapter>(new ParentAdapter(this), variant, this.verifier);
        }

        public BlockState finish() {
            return this.parent.variant(new VariantModel(new LinkedHashMap<String, VariantModel.VariantData>(this.variants)));
        }

        VariantModelBuilder variant(String name, SingleOrWeightedData data) {
            this.checkVariant(name);
            this.variants.put(name, new VariantModel.VariantData(data));
            return this;
        }

        private void checkVariant(String name) {
            if (this.variants.containsKey(Objects.requireNonNull(name))) {
                throw new IllegalArgumentException("Already created data for variant " + name);
            }
        }

        private record ParentAdapter(VariantModelBuilder parent) implements WeightedModelBuilder.Parent<VariantModelBuilder>
        {
            @Override
            public VariantModelBuilder variant(String name, SingleOrWeightedData data) {
                return this.parent().variant(name, data);
            }
        }
    }

    @FunctionalInterface
    private static interface ModelVerifier {
        public void checkModel(ResourceLocation var1, int var2, int var3, boolean var4);
    }

    public static final class MultipartModelBuilder {
        private final BlockState parent;
        private final ModelVerifier verifier;
        private final List<MultipartModel.MultipartSection> sections;

        MultipartModelBuilder(BlockState parent, ModelVerifier verifier) {
            this.parent = parent;
            this.verifier = verifier;
            this.sections = new ArrayList<MultipartModel.MultipartSection>();
        }

        public MultipartSectionBuilder section() {
            return new MultipartSectionBuilder(this, this.verifier);
        }

        public BlockState finish() {
            if (this.sections.isEmpty()) {
                throw new IllegalArgumentException("No sections specified");
            }
            return this.parent.multipart(new MultipartModel(new ArrayList<MultipartModel.MultipartSection>(this.sections)));
        }

        MultipartModelBuilder section(MultipartModel.MultipartSection section) {
            this.sections.add(section);
            return this;
        }
    }

    private record VariantModel(Map<String, VariantData> variants) {
        JsonElement serialize() {
            JsonObject main = new JsonObject();
            JsonObject object = new JsonObject();
            this.variants().forEach((name, data) -> object.add(name, data.serialize()));
            main.add("variants", (JsonElement)object);
            return main;
        }

        private record VariantData(SingleOrWeightedData model) {
            JsonElement serialize() {
                return this.model().serialize();
            }
        }
    }

    private record MultipartModel(List<MultipartSection> sections) {
        JsonElement serialize() {
            JsonObject main = new JsonObject();
            JsonArray array = new JsonArray();
            this.sections().stream().map(MultipartSection::serialize).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            main.add("multiparts", (JsonElement)array);
            return main;
        }

        private record MultipartSection(List<MultipartCase> when, List<MultipartOrCase> or, SingleOrWeightedData apply) {
            JsonElement serialize() {
                JsonObject section = new JsonObject();
                JsonObject when = new JsonObject();
                if (!this.or().isEmpty()) {
                    JsonArray or = new JsonArray();
                    this.or().stream().map(MultipartOrCase::serialize).forEach(arg_0 -> ((JsonArray)or).add(arg_0));
                    when.add("OR", (JsonElement)or);
                } else if (!this.when().isEmpty()) {
                    this.when().forEach(it -> when.addProperty(it.name(), it.value()));
                }
                if (!when.entrySet().isEmpty()) {
                    section.add("when", (JsonElement)when);
                }
                section.add("apply", this.apply().serialize());
                return section;
            }

            private record MultipartCase(String name, String value) {
            }

            private record MultipartOrCase(List<MultipartCase> cases) {
                JsonElement serialize() {
                    JsonObject object = new JsonObject();
                    this.cases().forEach(it -> object.addProperty(it.name(), it.value()));
                    return object;
                }
            }
        }
    }

    public static final class MultipartSectionBuilder {
        private final MultipartModelBuilder parent;
        private final ModelVerifier verifier;
        private final List<MultipartModel.MultipartSection.MultipartCase> cases;
        private final List<MultipartModel.MultipartSection.MultipartOrCase> or;
        private SingleOrWeightedData data;

        MultipartSectionBuilder(MultipartModelBuilder parent, ModelVerifier verifier) {
            this.parent = parent;
            this.verifier = verifier;
            this.cases = new ArrayList<MultipartModel.MultipartSection.MultipartCase>();
            this.or = new ArrayList<MultipartModel.MultipartSection.MultipartOrCase>();
            this.data = null;
        }

        public MultipartSectionBuilder when(String name, String value) {
            if (!this.or.isEmpty()) {
                throw new IllegalArgumentException("Cannot set 'when' case when 'or' is present");
            }
            this.cases.add(new MultipartModel.MultipartSection.MultipartCase(Objects.requireNonNull(name), Objects.requireNonNull(value)));
            return this;
        }

        public MultipartOrSectionBuilder or() {
            if (!this.cases.isEmpty()) {
                throw new IllegalArgumentException("Cannot set 'or' cases when 'when' is present");
            }
            return new MultipartOrSectionBuilder(this);
        }

        public WeightedModelBuilder<MultipartSectionBuilder, ParentAdapter> apply() {
            if (this.data != null) {
                throw new IllegalArgumentException("Already set model for multipart case");
            }
            return new WeightedModelBuilder<MultipartSectionBuilder, ParentAdapter>(new ParentAdapter(this), "<multipart>", this.verifier);
        }

        public MultipartModelBuilder finish() {
            if (!this.cases.isEmpty() && !this.or.isEmpty()) {
                throw new IllegalArgumentException("Both 'when' and 'or' specified");
            }
            return this.parent.section(new MultipartModel.MultipartSection(new ArrayList<MultipartModel.MultipartSection.MultipartCase>(this.cases), new ArrayList<MultipartModel.MultipartSection.MultipartOrCase>(this.or), this.data));
        }

        MultipartSectionBuilder or(MultipartModel.MultipartSection.MultipartOrCase or) {
            if (!this.cases.isEmpty()) {
                throw new IllegalArgumentException("Cannot set 'or' cases when 'when' is present");
            }
            this.or.add(or);
            return this;
        }

        MultipartSectionBuilder variant(SingleOrWeightedData data) {
            this.data = data;
            return this;
        }

        private record ParentAdapter(MultipartSectionBuilder parent) implements WeightedModelBuilder.Parent<MultipartSectionBuilder>
        {
            @Override
            public MultipartSectionBuilder variant(String name, SingleOrWeightedData data) {
                return this.parent().variant(data);
            }
        }
    }

    public static final class MultipartOrSectionBuilder {
        private final MultipartSectionBuilder parent;
        private final List<MultipartModel.MultipartSection.MultipartCase> conditions;

        MultipartOrSectionBuilder(MultipartSectionBuilder parent) {
            this.parent = parent;
            this.conditions = new ArrayList<MultipartModel.MultipartSection.MultipartCase>();
        }

        public MultipartOrSectionBuilder when(String name, String value) {
            this.conditions.add(new MultipartModel.MultipartSection.MultipartCase(Objects.requireNonNull(name), Objects.requireNonNull(value)));
            return this;
        }

        public MultipartSectionBuilder finish() {
            return this.parent.or(new MultipartModel.MultipartSection.MultipartOrCase(new ArrayList<MultipartModel.MultipartSection.MultipartCase>(this.conditions)));
        }
    }

    public static final class WeightedModelBuilder<T, U extends Parent<T>> {
        private final U parent;
        private final String name;
        private final ModelVerifier verifier;
        private final List<WeightedModelData> models;

        WeightedModelBuilder(U parent, String name, ModelVerifier verifier) {
            this.parent = parent;
            this.name = name;
            this.verifier = verifier;
            this.models = new ArrayList<WeightedModelData>();
        }

        public WeightedModelBuilder<T, U> add(ResourceLocation name, int weight) {
            return this.add(name, 0, 0, weight);
        }

        public WeightedModelBuilder<T, U> add(ResourceLocation name, int x, int y, int weight) {
            return this.add(name, x, y, false, weight);
        }

        public WeightedModelBuilder<T, U> add(ResourceLocation name, int x, int y, boolean uvLock, int weight) {
            this.verifier.checkModel(name, x, y, uvLock);
            if (weight <= 0) {
                throw new IllegalArgumentException("Invalid weight " + weight);
            }
            this.models.add(new WeightedModelData(new ModelData(name, x, y, uvLock), weight));
            return this;
        }

        public T finish() {
            if (this.models.isEmpty()) {
                throw new IllegalStateException("No model specified for variant " + this.name);
            }
            return (T)this.parent.variant(this.name, new SingleOrWeightedData(null, new ArrayList<WeightedModelData>(this.models)));
        }

        @FunctionalInterface
        static interface Parent<J> {
            public J variant(String var1, SingleOrWeightedData var2);
        }
    }

    private record SingleOrWeightedData(ModelData single, List<WeightedModelData> multiple) {
        JsonElement serialize() {
            if (this.single() != null) {
                return this.single().serialize();
            }
            JsonArray array = new JsonArray();
            this.multiple().stream().map(WeightedModelData::serialize).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            return array;
        }
    }

    private record WeightedModelData(ModelData data, int weight) {
        JsonElement serialize() {
            JsonObject object = this.data().serialize().getAsJsonObject();
            object.addProperty("weight", (Number)this.weight());
            return object;
        }
    }

    private record ModelData(ResourceLocation name, int x, int y, boolean uvLock) {
        JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("model", this.name().toString());
            object.addProperty("x", (Number)this.x());
            object.addProperty("y", (Number)this.y());
            object.addProperty("uvlock", Boolean.valueOf(this.uvLock()));
            return object;
        }
    }
}

