/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public final class ItemModel {
    public static final ResourceSerializer<ItemModel> SERIALIZER = ItemModel::serialize;
    private final ResourceLocation parent;
    private final Map<DisplayPosition, DisplayData> positions;
    private final Map<String, ResourceLocation> textures;
    private final List<Element> elements;
    private final List<ModelOverride> overrides;
    private GuiLight light;

    private ItemModel(ResourceLocation parent) {
        this.parent = parent;
        this.positions = new HashMap<DisplayPosition, DisplayData>();
        this.textures = new HashMap<String, ResourceLocation>();
        this.elements = new ArrayList<Element>();
        this.overrides = new ArrayList<ModelOverride>();
        this.light = null;
    }

    public static ItemModel of(ResourceLocation parent) {
        return new ItemModel(parent);
    }

    public static ItemModel ofGenerated() {
        return new ItemModel(new ResourceLocation("item/generated"));
    }

    public ItemModel display(DisplayPosition position, Vector3d rotation, Vector3d translation, Vector3d scale) {
        Objects.requireNonNull(position);
        if (rotation == null && translation == null && scale == null) {
            throw new IllegalArgumentException("At least one between rotation, translation, and scale must be set");
        }
        if (this.positions.containsKey((Object)position)) {
            throw new IllegalArgumentException("Position " + position + " is already set");
        }
        this.positions.put(position, new DisplayData(this.clone(rotation), this.clone(translation), this.clone(scale)));
        return this;
    }

    public ItemModel guiLight(GuiLight light) {
        this.light = Objects.requireNonNull(light);
        return this;
    }

    public ElementBuilder element(Vector3d from, Vector3d to) {
        return this.element(from, to, true);
    }

    public ElementBuilder element(Vector3d from, Vector3d to, boolean shade) {
        return new ElementBuilder(this, Objects.requireNonNull(from), Objects.requireNonNull(to), shade);
    }

    public ItemModel texture(String name, ResourceLocation path) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(path);
        if (this.textures.containsKey(name)) {
            throw new IllegalArgumentException("Texture was already specified for " + name);
        }
        this.textures.put(name, path);
        return this;
    }

    public ItemModel particle(ResourceLocation path) {
        return this.texture("particle", path);
    }

    public ItemModel layer(int id, ResourceLocation path) {
        if (id < 0) {
            throw new IllegalStateException("Invalid id " + id + " for layer");
        }
        return this.texture("layer" + id, path);
    }

    public OverrideBuilder override(ResourceLocation model) {
        return new OverrideBuilder(this, Objects.requireNonNull(model));
    }

    private ItemModel element(Element element) {
        this.elements.add(element);
        return this;
    }

    private ItemModel override(ModelOverride override) {
        this.overrides.add(override);
        return this;
    }

    private Vector3d clone(Vector3d original) {
        return original != null ? new Vector3d(original.f_86214_, original.f_86215_, original.f_86216_) : null;
    }

    private byte[] serialize() {
        JsonObject object = new JsonObject();
        if (this.parent != null) {
            object.addProperty("parent", this.parent.toString());
        }
        if (!this.positions.isEmpty()) {
            JsonObject positions = new JsonObject();
            this.positions.forEach((position, data) -> {
                JsonObject jsonData = new JsonObject();
                this.serializeVector(jsonData, "rotation", data.rotation());
                this.serializeVector(jsonData, "translation", data.translation());
                this.serializeVector(jsonData, "scale", data.scale());
                positions.add(position.toString(), (JsonElement)jsonData);
            });
            object.add("display", (JsonElement)positions);
        }
        if (!this.textures.isEmpty()) {
            JsonObject textures = new JsonObject();
            this.textures.forEach((name, id) -> textures.addProperty(name, id.toString()));
            object.add("textures", (JsonElement)textures);
        }
        if (this.light != null) {
            object.addProperty("gui_light", this.light.toString());
        }
        if (!this.elements.isEmpty()) {
            JsonArray elements = new JsonArray();
            this.elements.forEach(element -> elements.add(element.serialize(this::serializeVector, this::serializeVector)));
            object.add("elements", (JsonElement)elements);
        }
        if (!this.overrides.isEmpty()) {
            JsonArray overrides = new JsonArray();
            this.overrides.forEach(override -> overrides.add(override.serialize()));
            object.add("overrides", (JsonElement)overrides);
        }
        return StandardResourceSerializers.JSON.serialize((JsonElement)object);
    }

    private void serializeVector(JsonObject object, String name, Vector3d vector) {
        if (vector == null) {
            return;
        }
        JsonArray array = new JsonArray();
        array.add((JsonElement)new JsonPrimitive((Number)vector.f_86214_));
        array.add((JsonElement)new JsonPrimitive((Number)vector.f_86215_));
        array.add((JsonElement)new JsonPrimitive((Number)vector.f_86216_));
        object.add(name, (JsonElement)array);
    }

    private void serializeVector(JsonObject object, String name, Vector4f vector) {
        if (vector == null) {
            return;
        }
        JsonArray array = new JsonArray();
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.m_123601_())));
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.m_123615_())));
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.m_123616_())));
        array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(vector.m_123617_())));
        object.add(name, (JsonElement)array);
    }

    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String id;

        private GuiLight(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum DisplayPosition {
        THIRD_RIGHT("thirdperson_righthand"),
        THIRD_LEFT("thirdperson_lefthand"),
        FIRST_RIGHT("firstperson_righthand"),
        FIRST_LEFT("firstperson_lefthand"),
        GUI("gui"),
        HEAD("head"),
        GROUND("ground"),
        FIXED("fixed");

        private final String id;

        private DisplayPosition(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    private record DisplayData(Vector3d rotation, Vector3d translation, Vector3d scale) {
    }

    public static final class ElementBuilder {
        private final ItemModel parent;
        private final Vector3d from;
        private final Vector3d to;
        private final boolean shade;
        private final Map<FacePosition, Element.Face> faces;
        private Element.Rotation rotation;

        ElementBuilder(ItemModel parent, Vector3d from, Vector3d to, boolean shade) {
            this.parent = parent;
            this.from = from;
            this.to = to;
            this.shade = shade;
            this.faces = new HashMap<FacePosition, Element.Face>();
            this.rotation = null;
        }

        public ElementBuilder rotate(Vector3d origin, RotationAxis axis, float angle) {
            return this.rotate(origin, axis, angle, false);
        }

        public ElementBuilder rotate(Vector3d origin, RotationAxis axis, float angle, boolean rescale) {
            Objects.requireNonNull(origin);
            Objects.requireNonNull(axis);
            if (angle != -45.0f && (double)angle != -22.5 && angle != 0.0f && (double)angle != 22.5 && angle != 45.0f) {
                throw new IllegalArgumentException("Invalid angle for rotation " + angle);
            }
            this.rotation = new Element.Rotation(origin, axis, angle, rescale);
            return this;
        }

        public ElementBuilder face(FacePosition position, String texture) {
            return this.face(position, null, texture);
        }

        public ElementBuilder face(FacePosition position, Vector4f uvs, String texture) {
            return this.face(position, uvs, texture, null);
        }

        public ElementBuilder face(FacePosition position, Vector4f uvs, String texture, FacePosition cull) {
            return this.face(position, uvs, texture, cull, 0);
        }

        public ElementBuilder face(FacePosition position, Vector4f uvs, String texture, int rotation) {
            return this.face(position, uvs, texture, null, rotation);
        }

        public ElementBuilder face(FacePosition position, Vector4f uvs, String texture, FacePosition cull, int rotation) {
            return this.face(position, uvs, texture, cull, rotation, null);
        }

        public ElementBuilder face(FacePosition position, Vector4f uvs, String texture, FacePosition cull, int rotation, Integer tintIndex) {
            Objects.requireNonNull(position);
            Objects.requireNonNull(texture);
            if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
                throw new IllegalArgumentException("Invalid angle for rotation " + rotation);
            }
            if (this.faces.containsKey((Object)position)) {
                throw new IllegalArgumentException("Face for position " + position + " was already specified");
            }
            this.faces.put(position, new Element.Face(uvs, texture, cull, rotation, tintIndex));
            return this;
        }

        public ItemModel finish() {
            return this.parent.element(new Element(this.from, this.to, this.rotation, this.shade, this.faces));
        }
    }

    public static final class OverrideBuilder {
        private final ItemModel parent;
        private final ResourceLocation model;
        private final List<ModelOverride.Predicate> predicates;

        OverrideBuilder(ItemModel parent, ResourceLocation model) {
            this.parent = parent;
            this.model = model;
            this.predicates = new ArrayList<ModelOverride.Predicate>();
        }

        public OverrideBuilder when(String name, float value) {
            Objects.requireNonNull(name);
            this.predicates.add(new ModelOverride.Predicate(name, value));
            return this;
        }

        public ItemModel finish() {
            return this.parent.override(new ModelOverride(this.predicates, this.model));
        }
    }

    private record ModelOverride(List<Predicate> predicates, ResourceLocation model) {
        JsonElement serialize() {
            JsonObject object = new JsonObject();
            JsonObject predicates = new JsonObject();
            this.predicates().forEach(predicate -> predicates.addProperty(predicate.name(), (Number)Float.valueOf(predicate.value())));
            object.add("predicate", (JsonElement)predicates);
            object.addProperty("model", this.model().toString());
            return object;
        }

        record Predicate(String name, float value) {
        }
    }

    @FunctionalInterface
    private static interface VectorSerializer<T> {
        public void serializeVector(JsonObject var1, String var2, T var3);
    }

    private record Element(Vector3d from, Vector3d to, Rotation rotation, boolean shade, Map<FacePosition, Face> faces) {
        JsonElement serialize(VectorSerializer<Vector3d> threeSerializer, VectorSerializer<Vector4f> fourSerializer) {
            JsonObject object = new JsonObject();
            threeSerializer.serializeVector(object, "from", this.from());
            threeSerializer.serializeVector(object, "to", this.to());
            if (this.rotation() != null) {
                JsonObject rotation = new JsonObject();
                threeSerializer.serializeVector(rotation, "origin", this.rotation().origin());
                rotation.addProperty("axis", this.rotation().axis().toString());
                rotation.addProperty("angle", (Number)Float.valueOf(this.rotation().angle()));
                rotation.addProperty("rescale", Boolean.valueOf(this.rotation().scale()));
                object.add("rotation", (JsonElement)rotation);
            }
            object.addProperty("shade", Boolean.valueOf(this.shade()));
            if (!this.faces().isEmpty()) {
                JsonObject faces = new JsonObject();
                this.faces().forEach((position, face) -> faces.add(position.toString(), face.serialize(fourSerializer)));
                object.add("faces", (JsonElement)faces);
            }
            return object;
        }

        record Rotation(Vector3d origin, RotationAxis axis, float angle, boolean scale) {
        }

        record Face(Vector4f uv, String texture, FacePosition cull, int rotation, Integer tintIndex) {
            JsonElement serialize(VectorSerializer<Vector4f> fourSerializer) {
                JsonObject object = new JsonObject();
                fourSerializer.serializeVector(object, "uv", this.uv);
                object.addProperty("texture", "#%s".formatted(this.texture()));
                if (this.cull() != null) {
                    object.addProperty("cullface", this.cull().toString());
                }
                object.addProperty("rotation", (Number)this.rotation());
                if (this.tintIndex() != null) {
                    object.addProperty("tintindex", (Number)this.tintIndex());
                }
                return object;
            }
        }
    }

    public static enum FacePosition {
        DOWN("down"),
        UP("up"),
        NORTH("north"),
        SOUTH("south"),
        WEST("west"),
        EAST("east");

        private final String id;

        private FacePosition(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum RotationAxis {
        X("x"),
        Y("y"),
        Z("z");

        private final String id;

        private RotationAxis(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

