/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.base.Suppliers;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public final class PathHelper {
    private static final Supplier<Map<ObjectType<?>, String>> SPECIAL_TAGS = Suppliers.memoize(() -> Map.of(VanillaObjectTypes.BLOCK, "blocks", VanillaObjectTypes.ITEM, "items"));

    private PathHelper() {
    }

    public static String blockLootTable(ResourceLocation name) {
        return PathHelper.lootTable(new ResourceLocation(Objects.requireNonNull(name).m_135827_(), "blocks/%s".formatted(name.m_135815_())));
    }

    public static String blockModel(ResourceLocation name) {
        return "models/block/%s.json".formatted(Objects.requireNonNull(name).m_135815_());
    }

    public static String blockState(ResourceLocation name) {
        return "blockstates/%s.json".formatted(Objects.requireNonNull(name).m_135815_());
    }

    public static String itemModel(ResourceLocation name) {
        return "models/item/%s.json".formatted(Objects.requireNonNull(name).m_135815_());
    }

    public static String lang(String language) {
        return "lang/%s.json".formatted(Objects.requireNonNull(language));
    }

    public static String lootTable(ResourceLocation table) {
        return "loot_tables/%s.json".formatted(Objects.requireNonNull(table).m_135815_());
    }

    public static String sound(ResourceLocation id) {
        return "sounds/%s.ogg".formatted(Objects.requireNonNull(id).m_135815_());
    }

    public static String texture(ResourceLocation name) {
        return "textures/%s.png".formatted(Objects.requireNonNull(name).m_135815_());
    }

    public static String tag(ObjectType<?> type, ResourceLocation name) {
        String path = SPECIAL_TAGS.get().containsKey(Objects.requireNonNull(type)) ? SPECIAL_TAGS.get().get(type) : Objects.requireNonNull(type.key()).m_135782_().m_135815_();
        return "tags/%s/%s.json".formatted(path, Objects.requireNonNull(name).m_135815_());
    }

    public static String usLang() {
        return PathHelper.lang("en_us");
    }
}

