/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.resource;

import com.blamejared.contenttweaker.core.api.resource.ResourceSerializer;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;

public final class SoundDefinition {
    public static final ResourceSerializer<SoundDefinition> SERIALIZER = SoundDefinition::serialize;
    private final Map<String, Definition> definitions = new LinkedHashMap<String, Definition>();

    private SoundDefinition() {
    }

    public static SoundDefinition of() {
        return new SoundDefinition();
    }

    public DefinitionBuilder add(String name) {
        if (this.definitions.containsKey(Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("Definition for " + name + " already exists");
        }
        return new DefinitionBuilder(it -> (SoundDefinition)Util.m_137469_((Object)this, def -> def.definitions.put(name, (Definition)it)));
    }

    public DefinitionBuilder add(ResourceLocation name) {
        return this.add(Objects.requireNonNull(name).m_135815_());
    }

    private byte[] serialize() {
        JsonObject object = new JsonObject();
        this.definitions.forEach((name, definition) -> object.add(name, definition.serialize()));
        return StandardResourceSerializers.JSON.serialize((JsonElement)object);
    }

    public static final class DefinitionBuilder {
        private final Function<Definition, SoundDefinition> definition;
        private final List<Sound> sounds;
        private String subtitle;

        DefinitionBuilder(Function<Definition, SoundDefinition> definition) {
            this.definition = definition;
            this.sounds = new ArrayList<Sound>();
            this.subtitle = null;
        }

        public DefinitionBuilder subtitle(String subtitle) {
            Objects.requireNonNull(subtitle);
            this.subtitle = subtitle;
            return this;
        }

        public SoundBuilder sound(ResourceLocation name) {
            Objects.requireNonNull(name);
            return new SoundBuilder(name, sound -> (DefinitionBuilder)Util.m_137469_((Object)this, def -> def.sounds.add((Sound)sound)));
        }

        public SoundDefinition finish() {
            if (this.sounds.isEmpty()) {
                throw new IllegalStateException("No sounds");
            }
            return this.definition.apply(new Definition(this.sounds, this.subtitle));
        }
    }

    private record Definition(List<Sound> sounds, String subtitle) {
        JsonElement serialize() {
            JsonObject definition = new JsonObject();
            if (this.subtitle() != null) {
                definition.addProperty("subtitle", this.subtitle());
            }
            JsonArray sounds = new JsonArray();
            this.sounds().stream().map(Sound::serialize).forEach(arg_0 -> ((JsonArray)sounds).add(arg_0));
            definition.add("sounds", (JsonElement)sounds);
            return definition;
        }
    }

    private record Sound(ResourceLocation name, SoundType type, float volume, float pitch, int weight, boolean stream, int attenuation, boolean preload) {
        JsonElement serialize() {
            JsonObject sound = new JsonObject();
            sound.addProperty("name", this.name().toString());
            sound.addProperty("type", this.type().toString());
            sound.addProperty("volume", (Number)Float.valueOf(this.volume()));
            sound.addProperty("pitch", (Number)Float.valueOf(this.pitch()));
            sound.addProperty("weight", (Number)this.weight());
            sound.addProperty("stream", Boolean.valueOf(this.stream()));
            sound.addProperty("preload", Boolean.valueOf(this.preload()));
            sound.addProperty("attenuation_distance", (Number)this.attenuation());
            return sound;
        }
    }

    public static final class SoundBuilder {
        private final Function<Sound, DefinitionBuilder> builder;
        private final ResourceLocation name;
        private SoundType type;
        private Float volume;
        private Float pitch;
        private Integer weight;
        private Boolean stream;
        private Integer attenuation;
        private Boolean preload;

        SoundBuilder(ResourceLocation name, Function<Sound, DefinitionBuilder> builder) {
            this.builder = builder;
            this.name = name;
            this.type = null;
            this.volume = null;
            this.pitch = null;
            this.weight = null;
            this.stream = null;
            this.attenuation = null;
            this.preload = null;
        }

        public SoundBuilder type(SoundType type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public SoundBuilder volume(float volume) {
            this.volume = Float.valueOf(volume);
            return this;
        }

        public SoundBuilder pitch(float pitch) {
            this.pitch = Float.valueOf(pitch);
            return this;
        }

        public SoundBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public SoundBuilder attenuationDistance(int attenuation) {
            this.attenuation = attenuation;
            return this;
        }

        public SoundBuilder preload() {
            this.preload = true;
            return this;
        }

        public SoundBuilder stream() {
            this.stream = true;
            return this;
        }

        public DefinitionBuilder finish() {
            SoundType type = this.type == null ? SoundType.SOUND : this.type;
            float volume = this.volume == null ? 1.0f : this.volume.floatValue();
            float pitch = this.pitch == null ? 1.0f : this.pitch.floatValue();
            int weight = this.weight == null ? 1 : this.weight;
            boolean stream = this.stream != null && this.stream != false;
            int attenuation = this.attenuation == null ? 16 : this.attenuation;
            boolean preload = this.preload != null && this.preload != false;
            return this.builder.apply(new Sound(this.name, type, volume, pitch, weight, stream, attenuation, preload));
        }
    }

    public static enum SoundType {
        SOUND("file"),
        EVENT("event");

        private final String id;

        private SoundType(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

