/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.block;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.contenttweaker.vanilla.api.ContentTweakerVanillaApi;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.LootTable;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.BlockItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.factory.ItemFactory;
import com.blamejared.contenttweaker.vanilla.api.zen.object.BlockReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.CreativeTabReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.BlockProperties;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.BlockPropertyFunctions;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.StandardBlockProperties;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.block.BlockBuilder")
@ZenRegister(loaders={"contenttweaker"})
public abstract class BlockBuilder<T extends BlockBuilder<T>> {
    protected static final String LOOT_GEN_FAILURE_DUE_TO_NO_ITEM = "Unable to automatically generate loot table for block '%s' because the automatic block item has been disabled: an empty one will be generated instead";
    private static final ResourceLocation DO_NOT_CLONE_DROPS = ContentTweakerConstants.rl("do_not_clone_drops");
    private static final ResourceLocation DO_NOT_DROP_DROPS = ContentTweakerConstants.rl("do_not_drop_drops");
    private static final ResourceLocation FORCE_GENERATION_OF_DROPS = ContentTweakerConstants.rl("force_generation_of_drops");
    private final BiFunction<ObjectHolder<? extends Block>, Consumer<ResourceManager>, BlockReference> registrationManager;
    private StandardBlockProperties cloningProperties;
    private Reference<Material> material;
    private BlockPropertyFunctions.MaterialColorFinder materialColor;
    private Boolean hasCollision;
    private Reference<SoundType> soundType;
    private BlockPropertyFunctions.LightLevelComputer lightEmission;
    private Float explosionResistance;
    private Float destroyTime;
    private Boolean requiresTool;
    private Boolean ticksRandomly;
    private Float friction;
    private Float speed;
    private Float jump;
    private ResourceLocation drops;
    private Boolean occlude;
    private Boolean air;
    private Boolean dynamic;
    private CreativeTabReference tab;
    private boolean blockItem;

    protected BlockBuilder(BiFunction<ObjectHolder<? extends Block>, Consumer<ResourceManager>, BlockReference> registrationManager) {
        this.registrationManager = Objects.requireNonNull(registrationManager);
        this.cloningProperties = null;
        this.material = null;
        this.materialColor = null;
        this.hasCollision = null;
        this.soundType = null;
        this.lightEmission = null;
        this.explosionResistance = null;
        this.destroyTime = null;
        this.requiresTool = null;
        this.ticksRandomly = null;
        this.friction = null;
        this.speed = null;
        this.jump = null;
        this.drops = null;
        this.occlude = null;
        this.air = null;
        this.dynamic = null;
        this.tab = null;
        this.blockItem = true;
    }

    @ZenCodeType.Method(value="cloning")
    public T cloning(BlockProperties properties) {
        StandardBlockProperties standard;
        Objects.requireNonNull(properties);
        StandardBlockProperties standardBlockProperties = standard = "standard".equals(properties.type()) ? (StandardBlockProperties)properties : null;
        if (standard == null) {
            throw new IllegalArgumentException("Unknown set of properties " + properties.type() + " to clone from");
        }
        if (this.cloningProperties != null) {
            throw new IllegalStateException("Already specified properties to clone from");
        }
        this.cloningProperties = standard;
        return this.self();
    }

    @ZenCodeType.Method(value="material")
    public T material(Reference<Material> reference) {
        this.material = reference;
        return this.self();
    }

    @ZenCodeType.Method(value="overridingMaterialColor")
    public T overridingMaterialColor(BlockPropertyFunctions.MaterialColorFinder finder) {
        this.materialColor = finder;
        return this.self();
    }

    @ZenCodeType.Method(value="hasCollisions")
    public T hasCollisions(boolean collisions) {
        this.hasCollision = collisions;
        return this.self();
    }

    @ZenCodeType.Method(value="noCollisions")
    public T noCollisions() {
        return this.hasCollisions(false);
    }

    @ZenCodeType.Method(value="sound")
    public T sound(Reference<SoundType> reference) {
        this.soundType = reference;
        return this.self();
    }

    @ZenCodeType.Method(value="lightLevel")
    public T lightLevel(BlockPropertyFunctions.LightLevelComputer lightLevelComputer) {
        this.lightEmission = lightLevelComputer;
        return this.self();
    }

    @ZenCodeType.Method(value="lightLevel")
    public T lightLevel(int level) {
        if (level < 0 || level > 15) {
            throw new IllegalArgumentException("Invalid light level " + level + ": must be between 0 and 15");
        }
        return this.lightLevel(it -> level);
    }

    @ZenCodeType.Method(value="explosionResistance")
    public T explosionResistance(float explosionResistance) {
        if (explosionResistance < 0.0f) {
            throw new IllegalArgumentException("Explosion resistance cannot be negative");
        }
        this.explosionResistance = Float.valueOf(explosionResistance);
        return this.self();
    }

    @ZenCodeType.Method(value="destroyTime")
    public T destroyTime(float destroyTime) {
        this.destroyTime = Float.valueOf(destroyTime);
        return this.self();
    }

    @ZenCodeType.Method(value="strength")
    public T strength(float destroyTime, float explosionResistance) {
        return ((BlockBuilder)this.explosionResistance(explosionResistance)).destroyTime(destroyTime);
    }

    @ZenCodeType.Method(value="strength")
    public T strength(float strength) {
        return this.strength(strength, strength);
    }

    @ZenCodeType.Method(value="instabreak")
    public T breakInstantly() {
        return this.strength(0.0f);
    }

    @ZenCodeType.Method(value="requiresToolToDrop")
    public T requiresToolToDrop(boolean requiresTool) {
        this.requiresTool = requiresTool;
        return this.self();
    }

    @ZenCodeType.Method(value="requiresToolToDrop")
    public T requiresToolToDrop() {
        return this.requiresToolToDrop(true);
    }

    @ZenCodeType.Method(value="ticksRandomly")
    public T ticksRandomly(boolean ticksRandomly) {
        this.ticksRandomly = ticksRandomly;
        return this.self();
    }

    @ZenCodeType.Method(value="ticksRandomly")
    public T ticksRandomly() {
        return this.ticksRandomly(true);
    }

    @ZenCodeType.Method(value="friction")
    public T friction(float friction) {
        this.friction = Float.valueOf(friction);
        return this.self();
    }

    @ZenCodeType.Method(value="speedFactor")
    public T speedFactor(float speed) {
        this.speed = Float.valueOf(speed);
        return this.self();
    }

    @ZenCodeType.Method(value="jumpFactor")
    public T jumpFactor(float jump) {
        this.jump = Float.valueOf(jump);
        return this.self();
    }

    @ZenCodeType.Method(value="dropsFrom")
    public T dropsFrom(ResourceLocation drops) {
        this.drops = drops;
        return this.self();
    }

    @ZenCodeType.Method(value="dropsLike")
    public T dropsLike(BlockReference reference) {
        return this.dropsFrom(reference.id());
    }

    @ZenCodeType.Method(value="noDrops")
    public T noDrops() {
        return this.dropsFrom(DO_NOT_DROP_DROPS);
    }

    @ZenCodeType.Method(value="dropsNormally")
    public T dropsNormally() {
        return this.cloningProperties != null ? this.dropsFrom(DO_NOT_CLONE_DROPS) : this.self();
    }

    @ZenCodeType.Method(value="dropsItselfRegardless")
    public T dropsItselfRegardless() {
        return this.dropsFrom(FORCE_GENERATION_OF_DROPS);
    }

    @ZenCodeType.Method(value="occludes")
    public T occludes(boolean occlude) {
        this.occlude = occlude;
        return this.self();
    }

    @ZenCodeType.Method(value="noOcclusion")
    public T noOcclusion() {
        return this.occludes(false);
    }

    @ZenCodeType.Method(value="air")
    public T air(boolean air) {
        this.air = air;
        return this.self();
    }

    @ZenCodeType.Method(value="air")
    public T air() {
        return this.air(true);
    }

    @ZenCodeType.Method(value="dynamicShape")
    public T dynamicShape(boolean dynamic) {
        this.dynamic = dynamic;
        return this.self();
    }

    @ZenCodeType.Method(value="dynamicShape")
    public T dynamicShape() {
        return this.dynamicShape(true);
    }

    @ZenCodeType.Method(value="generateCorrespondingItem")
    public T generateCorrespondingItem(boolean enable) {
        this.blockItem = enable;
        return this.self();
    }

    @ZenCodeType.Method(value="noCorrespondingItem")
    public T noCorrespondingItem() {
        return this.generateCorrespondingItem(false);
    }

    @ZenCodeType.Method(value="tab")
    public T tab(CreativeTabReference reference) {
        this.tab = reference;
        return this.self();
    }

    @ZenCodeType.Method(value="build")
    public final BlockReference build(String name) {
        ResourceLocation id = ContentTweakerConstants.rl(name);
        GenerateFlags flags = this.flags();
        BlockReference reference = this.registrationManager.apply(this.create(id, this.checkAndMakeProperties(), flags), manager -> this.provideResources(id, (ResourceManager)manager, flags));
        if (flags.generateBlockItem()) {
            this.makeBlockItem(reference);
        }
        return reference;
    }

    public abstract ObjectHolder<? extends Block> create(ResourceLocation var1, Supplier<BlockBehaviour.Properties> var2, GenerateFlags var3);

    public abstract void provideResources(ResourceLocation var1, ResourceManager var2, GenerateFlags var3);

    protected final Optional<LootTable> emptyTable(ResourceLocation name, Function<ResourceLocation, String> messageSupplier) {
        String message = (String)Objects.requireNonNullElseGet(messageSupplier, () -> it -> null).apply(Objects.requireNonNull(name));
        if (message != null) {
            CraftTweakerAPI.LOGGER.warn(message);
        }
        return Optional.of(LootTable.ofBlock());
    }

    protected final Optional<LootTable> selfLootTable(ResourceLocation name, GenerateFlags flags) {
        Objects.requireNonNull(name);
        if (!Objects.requireNonNull(flags).generateBlockItem() && this.drops != FORCE_GENERATION_OF_DROPS) {
            return Optional.empty();
        }
        LootTable table = LootTable.ofBlock().pool().rolls(1).bonusRolls(0.0f).conditionally(new ResourceLocation("survives_explosion"), new JsonObject()).entry(new ResourceLocation("item")).name(name.toString()).finish().finish();
        return Optional.of(table);
    }

    private GenerateFlags flags() {
        boolean generateLootTable = this.drops == null || this.drops == FORCE_GENERATION_OF_DROPS || this.drops == DO_NOT_CLONE_DROPS;
        return new GenerateFlags(generateLootTable, this.blockItem);
    }

    private Supplier<BlockBehaviour.Properties> checkAndMakeProperties() {
        return this.cloningProperties != null ? this.checkAndMakeWithOverrides() : this.checkAndMakeQuick();
    }

    private Supplier<BlockBehaviour.Properties> checkAndMakeWithOverrides() {
        this.checkCommon();
        return this::makeWithOverrides;
    }

    private Supplier<BlockBehaviour.Properties> checkAndMakeQuick() {
        if (this.material == null) {
            throw new IllegalStateException("Unable to create a property instance without a material");
        }
        this.checkCommon();
        return this::makeQuick;
    }

    private void checkCommon() {
        if (this.hasCollision != null && !this.hasCollision.booleanValue() && this.occlude != null && this.occlude.booleanValue()) {
            throw new IllegalStateException("A block cannot both have no collisions and allow occlusion");
        }
        if (this.explosionResistance != null && this.explosionResistance.floatValue() < 0.0f) {
            throw new IllegalStateException("A block cannot have negative explosion resistance");
        }
    }

    private BlockBehaviour.Properties makeWithOverrides() {
        return this.make(this.material != null ? this.material : this.cloningProperties.material(), this.materialColor != null ? this.materialColor : this.cloningProperties.materialColor(), this.hasCollision != null ? this.hasCollision.booleanValue() : this.cloningProperties.hasCollision(), this.soundType != null ? this.soundType : this.cloningProperties.soundType(), this.lightEmission != null ? this.lightEmission : this.cloningProperties.lightEmission(), Float.valueOf(this.explosionResistance != null ? this.explosionResistance.floatValue() : this.cloningProperties.explosionResistance()), Float.valueOf(this.destroyTime != null ? this.destroyTime.floatValue() : this.cloningProperties.destroyTime()), this.requiresTool != null ? this.requiresTool.booleanValue() : this.cloningProperties.requiresCorrectToolForDrops(), this.ticksRandomly != null ? this.ticksRandomly.booleanValue() : this.cloningProperties.isRandomlyTicking(), Float.valueOf(this.friction != null ? this.friction.floatValue() : this.cloningProperties.friction()), Float.valueOf(this.speed != null ? this.speed.floatValue() : this.cloningProperties.speedFactor()), Float.valueOf(this.jump != null ? this.jump.floatValue() : this.cloningProperties.jumpFactor()), (ResourceLocation)(this.drops != null ? (this.drops == DO_NOT_CLONE_DROPS ? null : this.drops) : this.cloningProperties.drops()), this.occlude != null ? this.occlude.booleanValue() : this.cloningProperties.canOcclude(), this.air != null ? this.air.booleanValue() : this.cloningProperties.isAir(), this.dynamic != null ? this.dynamic.booleanValue() : this.cloningProperties.dynamicShape());
    }

    private BlockBehaviour.Properties makeQuick() {
        return this.make(this.material, this.materialColor, this.hasCollision, this.soundType, this.lightEmission, this.explosionResistance, this.destroyTime, this.requiresTool, this.ticksRandomly, this.friction, this.speed, this.jump, this.drops, this.occlude, this.air, this.dynamic);
    }

    private BlockBehaviour.Properties make(Reference<Material> materialReference, BlockPropertyFunctions.MaterialColorFinder materialColorFunction, Boolean hasCollision, Reference<SoundType> soundTypeReference, BlockPropertyFunctions.LightLevelComputer lightEmissionFunction, Float explosionResistance, Float destroyTime, Boolean requiresTool, Boolean ticksRandomly, Float friction, Float speed, Float jump, ResourceLocation drops, Boolean occlude, Boolean air, Boolean dynamic) {
        Material material = materialReference.get();
        Function<BlockState, MaterialColor> colorFunction = materialColorFunction == null ? x -> material.m_76339_() : x -> (MaterialColor)materialColorFunction.colorOf((BlockState)x).get();
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60947_((Material)material, colorFunction);
        if (hasCollision != null && !hasCollision.booleanValue()) {
            properties.m_60910_();
        }
        if (soundTypeReference != null) {
            properties.m_60918_(soundTypeReference.get());
        }
        if (lightEmissionFunction != null) {
            properties.m_60953_(lightEmissionFunction::lightOf);
        }
        if (explosionResistance != null) {
            properties.m_155956_(explosionResistance.floatValue());
        }
        if (destroyTime != null) {
            properties.m_155954_(destroyTime.floatValue());
        }
        if (requiresTool != null && requiresTool.booleanValue()) {
            properties.m_60999_();
        }
        if (ticksRandomly != null && ticksRandomly.booleanValue()) {
            properties.m_60977_();
        }
        if (friction != null) {
            properties.m_60911_(friction.floatValue());
        }
        if (speed != null) {
            properties.m_60956_(speed.floatValue());
        }
        if (jump != null) {
            properties.m_60967_(jump.floatValue());
        }
        if (drops != null && drops != DO_NOT_CLONE_DROPS && drops != FORCE_GENERATION_OF_DROPS) {
            if (drops == DO_NOT_DROP_DROPS) {
                properties.m_60993_();
            } else {
                ContentTweakerVanillaApi.get().blockPropertiesDrops(properties, drops);
            }
        }
        if (occlude != null && !occlude.booleanValue()) {
            properties.m_60955_();
        }
        if (air != null && air.booleanValue()) {
            properties.m_60996_();
        }
        if (dynamic != null && dynamic.booleanValue()) {
            properties.m_60988_();
        }
        return properties;
    }

    private void makeBlockItem(BlockReference reference) {
        ((BlockItemBuilder)ContentTweakerApi.get().registry().findObjectFactory(VanillaObjectTypes.ITEM, ItemFactory.class).of().typed(BlockItemBuilder.class).block(reference).tab(this.tab)).build(reference.id().m_135815_());
    }

    private T self() {
        return (T)((BlockBuilder)GenericUtil.uncheck((Object)this));
    }

    protected record GenerateFlags(boolean generateLootTable, boolean generateBlockItem) {
    }
}

