/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.ItemModel;
import com.blamejared.contenttweaker.vanilla.api.resource.Language;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.zen.ContentTweakerVanillaConstants;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.ItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.Basic")
@ZenRegister(loaders={"contenttweaker"})
public final class BasicItemBuilder
extends ItemBuilder<BasicItemBuilder> {
    public BasicItemBuilder(BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        super(registrationManager);
    }

    @Override
    public ObjectHolder<? extends Item> create(ResourceLocation name, Supplier<Item.Properties> builtProperties) {
        return ObjectHolder.of(VanillaObjectTypes.ITEM, name, () -> this.build((Item.Properties)builtProperties.get()));
    }

    @Override
    public void provideResources(ResourceLocation name, ResourceManager manager) {
        ResourceFragment cotAssets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        ResourceLocation textureName = new ResourceLocation(name.m_135827_(), "item/%s".formatted(name.m_135815_()));
        cotAssets.provideTemplated(PathHelper.texture(textureName), ContentTweakerVanillaConstants.itemTemplate("item"));
        cotAssets.provideFixed(PathHelper.itemModel(name), ItemModel.ofGenerated().layer(0, textureName), ItemModel.SERIALIZER);
        cotAssets.provideOrAlter(PathHelper.usLang(), Language::of, it -> it.item(name, "Custom Item"), Language.SERIALIZER);
    }

    private Item build(Item.Properties properties) {
        return new Item(properties);
    }
}

