/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.ItemModel;
import com.blamejared.contenttweaker.vanilla.api.resource.Language;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.ItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.object.BlockReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.BlockItem")
@ZenRegister(loaders={"contenttweaker"})
public final class BlockItemBuilder
extends ItemBuilder<BlockItemBuilder> {
    private BlockReference block = null;

    public BlockItemBuilder(BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        super(registrationManager);
    }

    @ZenCodeType.Method(value="block")
    public BlockItemBuilder block(BlockReference reference) {
        this.block = reference;
        return this;
    }

    @Override
    public ObjectHolder<? extends Item> create(ResourceLocation name, Supplier<Item.Properties> builtProperties) {
        Objects.requireNonNull(this.block);
        return ObjectHolder.of(VanillaObjectTypes.ITEM, name, () -> new ReferencingBlockItem(this.block, builtProperties));
    }

    @Override
    public void provideResources(ResourceLocation name, ResourceManager manager) {
        ResourceFragment cotAssets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        ResourceLocation blockModel = new ResourceLocation(this.block.id().m_135827_(), "block/%s".formatted(this.block.id().m_135815_()));
        cotAssets.provideFixed(PathHelper.itemModel(name), ItemModel.of(blockModel), ItemModel.SERIALIZER);
        cotAssets.provideOrAlter(PathHelper.usLang(), Language::of, it -> it.item(name, "Custom Block"), Language.SERIALIZER);
    }

    private static final class ReferencingBlockItem
    extends BlockItem {
        public ReferencingBlockItem(BlockReference reference, Supplier<Item.Properties> properties) {
            super((Block)reference.get(), properties.get());
        }
    }
}

