/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.ItemModel;
import com.blamejared.contenttweaker.vanilla.api.resource.Language;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.resource.Tag;
import com.blamejared.contenttweaker.vanilla.api.zen.ContentTweakerVanillaConstants;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.ToolItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.CustomTool")
@ZenRegister(loaders={"contenttweaker"})
public final class CustomToolItemBuilder
extends ToolItemBuilder<CustomToolItemBuilder> {
    private ResourceLocation tag = null;

    public CustomToolItemBuilder(BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        super(registrationManager);
    }

    @ZenCodeType.Method(value="tag")
    public CustomToolItemBuilder tag(ResourceLocation tag) {
        this.tag = Objects.requireNonNull(tag);
        return this;
    }

    @Override
    public ObjectHolder<? extends Item> createTool(ResourceLocation name, ToolItemBuilder.ToolData toolData, Supplier<Item.Properties> builtProperties) {
        if (this.tag == null) {
            throw new IllegalStateException("Unable to create a custom tool without a tag for blocks to mine");
        }
        return ObjectHolder.of(VanillaObjectTypes.ITEM, name, () -> new CustomDiggerItem(toolData, this.tag, builtProperties));
    }

    @Override
    public void provideResources(ResourceLocation name, ResourceManager manager) {
        ResourceFragment cotAssets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        ResourceFragment cotData = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_DATA);
        ResourceLocation texture = new ResourceLocation(name.m_135827_(), "item/%s".formatted(name.m_135815_()));
        cotAssets.provideTemplated(PathHelper.texture(texture), ContentTweakerVanillaConstants.itemTemplate("item"));
        cotAssets.provideFixed(PathHelper.itemModel(name), ItemModel.of(new ResourceLocation("item/handheld")).layer(0, texture), ItemModel.SERIALIZER);
        cotAssets.provideOrAlter(PathHelper.usLang(), Language::of, it -> it.item(name, "Custom Tool"), Language.SERIALIZER);
        cotData.provideOrAlter(PathHelper.tag(VanillaObjectTypes.BLOCK, this.tag), Tag::of, Function.identity(), Tag.SERIALIZER);
    }

    private static final class CustomDiggerItem
    extends DiggerItem {
        CustomDiggerItem(ToolItemBuilder.ToolData data, ResourceLocation tag, Supplier<Item.Properties> properties) {
            super(data.baseAttackDamage(), data.attackSpeed(), data.tier().get(), TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tag), properties.get());
        }
    }
}

