/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.ItemModel;
import com.blamejared.contenttweaker.vanilla.api.resource.Language;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.zen.ContentTweakerVanillaConstants;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.ToolItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.Hoe")
@ZenRegister(loaders={"contenttweaker"})
public final class HoeToolItemBuilder
extends ToolItemBuilder<HoeToolItemBuilder> {
    public HoeToolItemBuilder(BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        super(registrationManager);
    }

    @Override
    public ObjectHolder<? extends Item> createTool(ResourceLocation name, ToolItemBuilder.ToolData toolData, Supplier<Item.Properties> builtProperties) {
        if ((float)Mth.m_14143_((float)toolData.baseAttackDamage()) != toolData.baseAttackDamage()) {
            throw new IllegalStateException("Unable to create a hoe item with a non-whole attack damage");
        }
        return ObjectHolder.of(VanillaObjectTypes.ITEM, name, () -> new TotallyNotAHoe(toolData, builtProperties));
    }

    @Override
    public void provideResources(ResourceLocation name, ResourceManager manager) {
        ResourceFragment cotAssets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        ResourceLocation texture = new ResourceLocation(name.m_135827_(), "item/%s".formatted(name.m_135815_()));
        cotAssets.provideTemplated(PathHelper.texture(texture), ContentTweakerVanillaConstants.itemTemplate("hoe"));
        cotAssets.provideFixed(PathHelper.itemModel(name), ItemModel.of(new ResourceLocation("item/handheld")).layer(0, texture), ItemModel.SERIALIZER);
        cotAssets.provideOrAlter(PathHelper.usLang(), Language::of, it -> it.item(name, "Custom Hoe"), Language.SERIALIZER);
    }

    private static final class TotallyNotAHoe
    extends HoeItem {
        TotallyNotAHoe(ToolItemBuilder.ToolData data, Supplier<Item.Properties> properties) {
            super(data.tier().get(), (int)data.baseAttackDamage(), data.attackSpeed(), properties.get());
        }
    }
}

