/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.vanilla.api.zen.object.CreativeTabReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.FoodItemProperties;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.ItemProperties;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.StandardItemProperties;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.ItemBuilder")
@ZenRegister(loaders={"contenttweaker"})
public abstract class ItemBuilder<T extends ItemBuilder<T>> {
    private final BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager;
    private StandardItemProperties cloningProperties;
    private FoodItemProperties cloningFood;
    private Integer maxStackSize;
    private Integer maxDamage;
    private ItemReference remainder;
    private CreativeTabReference group;
    private Rarity rarity;
    private Boolean fireResistance;
    private Integer nutrition;
    private Float saturation;
    private Boolean meat;
    private Boolean alwaysEat;
    private Boolean fast;

    protected ItemBuilder(BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        this.registrationManager = Objects.requireNonNull(registrationManager, "registrationManager");
        this.cloningProperties = null;
        this.cloningFood = null;
        this.maxStackSize = null;
        this.maxDamage = null;
        this.remainder = null;
        this.group = null;
        this.rarity = null;
        this.fireResistance = null;
        this.nutrition = null;
        this.saturation = null;
        this.meat = null;
        this.alwaysEat = null;
        this.fast = null;
    }

    @ZenCodeType.Method(value="cloning")
    public T cloning(ItemProperties properties) {
        FoodItemProperties food;
        Objects.requireNonNull(properties);
        StandardItemProperties standard = "standard".equals(properties.type()) ? (StandardItemProperties)properties : null;
        FoodItemProperties foodItemProperties = food = "food".equals(properties.type()) ? (FoodItemProperties)properties : null;
        if (standard == null && food == null) {
            throw new IllegalArgumentException("Unknown set of properties " + properties.type() + " to clone from");
        }
        return this.cloning(standard, food);
    }

    @ZenCodeType.Method(value="cloning")
    public T cloning(@ZenCodeType.Nullable StandardItemProperties standard, @ZenCodeType.Nullable FoodItemProperties food) {
        if (standard == null && food == null) {
            throw new IllegalArgumentException("Unable to clone from no property set for both standard and food");
        }
        if (standard != null && this.cloningProperties != null || food != null && this.cloningFood != null) {
            throw new IllegalStateException("Already specified properties to clone from");
        }
        if (standard != null) {
            this.cloningProperties = standard;
        }
        if (food != null) {
            this.cloningFood = food;
        }
        return this.self();
    }

    @ZenCodeType.Method(value="stacksTo")
    public T stacksTo(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid stack size " + size);
        }
        if (size > 64) {
            CraftTweakerAPI.LOGGER.warn("Identified stack size bigger than 64: this will likely not work");
        }
        this.maxStackSize = size;
        return this.self();
    }

    @ZenCodeType.Method(value="durability")
    public T durability(int damage) {
        if (damage < 0) {
            throw new IllegalArgumentException("Invalid damage " + damage);
        }
        this.maxDamage = damage;
        return this.self();
    }

    @ZenCodeType.Method(value="craftRemainder")
    public T craftRemainder(ItemReference remainder) {
        this.remainder = remainder;
        return this.self();
    }

    @ZenCodeType.Method(value="tab")
    public T tab(CreativeTabReference tab) {
        this.group = tab;
        return this.self();
    }

    @ZenCodeType.Method(value="rarity")
    public T rarity(Rarity rarity) {
        this.rarity = rarity;
        return this.self();
    }

    @ZenCodeType.Method(value="fireResistant")
    public T fireResistant(boolean fireResistance) {
        this.fireResistance = fireResistance;
        return this.self();
    }

    @ZenCodeType.Method(value="nutrition")
    public T nutrition(int nutrition) {
        if (nutrition <= 0) {
            throw new IllegalArgumentException("Invalid nutrition " + nutrition);
        }
        this.nutrition = nutrition;
        return this.self();
    }

    @ZenCodeType.Method(value="saturationMod")
    public T saturationMod(float modifier) {
        if ((double)modifier < 0.0) {
            throw new IllegalArgumentException("Invalid saturation modifier " + modifier);
        }
        this.saturation = Float.valueOf(modifier);
        return this.self();
    }

    @ZenCodeType.Method(value="meat")
    public T meat(boolean meat) {
        this.meat = meat;
        return this.self();
    }

    @ZenCodeType.Method(value="canAlwaysEat")
    public T canAlwaysEat(boolean canEat) {
        this.alwaysEat = canEat;
        return this.self();
    }

    @ZenCodeType.Method(value="fastFood")
    public T fastFood(boolean fast) {
        this.fast = fast;
        return this.self();
    }

    @ZenCodeType.Method(value="build")
    public final ItemReference build(String name) {
        ResourceLocation id = ContentTweakerConstants.rl(name);
        return this.registrationManager.apply(this.create(id, this::makeProperties), manager -> this.provideResources(id, (ResourceManager)manager));
    }

    public abstract ObjectHolder<? extends Item> create(ResourceLocation var1, Supplier<Item.Properties> var2);

    public abstract void provideResources(ResourceLocation var1, ResourceManager var2);

    private Item.Properties makeProperties() {
        Item.Properties props = new Item.Properties();
        if (this.cloningProperties != null) {
            this.cloneInto(this.cloningProperties, props);
        }
        if (this.cloningFood != null) {
            this.cloneInto(this.cloningFood, props);
        }
        this.apply(props, this.maxDamage, this.maxStackSize, this.remainder, this.group, this.rarity, this.fireResistance, this.nutrition, this.saturation, this.meat, this.alwaysEat, this.fast);
        return props;
    }

    private void cloneInto(StandardItemProperties properties, Item.Properties out) {
        this.apply(out, properties.maxDamage(), properties.maxStackSize(), properties.craftingRemainingItem(), properties.category(), properties.rarity(), properties.isFireResistant(), null, null, null, null, null);
    }

    private void cloneInto(FoodItemProperties properties, Item.Properties out) {
        this.apply(out, null, null, null, null, null, null, properties.nutrition(), Float.valueOf(properties.saturationModifier()), properties.isMeat(), properties.canAlwaysEat(), properties.fastFood());
    }

    private void apply(Item.Properties out, Integer durability, Integer stack, ItemReference remainder, CreativeTabReference tab, Rarity rarity, Boolean fire, Integer nutrition, Float saturation, Boolean meat, Boolean alwaysEat, Boolean fast) {
        if (durability != null) {
            out.m_41503_(durability.intValue());
        }
        if (stack != null) {
            out.m_41487_(stack.intValue());
        }
        if (remainder != null) {
            out.m_41495_((Item)remainder.get());
        }
        if (tab != null) {
            out.m_41491_((CreativeModeTab)tab.get());
        }
        if (rarity != null) {
            out.m_41497_(rarity);
        }
        if (fire != null && fire.booleanValue()) {
            out.m_41486_();
        }
        if (nutrition != null || saturation != null || meat != null || alwaysEat != null || fast != null) {
            FoodProperties.Builder food = new FoodProperties.Builder();
            if (nutrition != null) {
                food.m_38760_(nutrition.intValue());
            }
            if (saturation != null) {
                food.m_38758_(saturation.floatValue());
            }
            if (meat != null && meat.booleanValue()) {
                food.m_38757_();
            }
            if (alwaysEat != null && alwaysEat.booleanValue()) {
                food.m_38765_();
            }
            if (fast != null && fast.booleanValue()) {
                food.m_38766_();
            }
            out.m_41489_(food.m_38767_());
        }
    }

    private T self() {
        return (T)((ItemBuilder)GenericUtil.uncheck((Object)this));
    }
}

