/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.core.api.resource.StandardResourceFragmentKeys;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.resource.ItemModel;
import com.blamejared.contenttweaker.vanilla.api.resource.Language;
import com.blamejared.contenttweaker.vanilla.api.resource.PathHelper;
import com.blamejared.contenttweaker.vanilla.api.zen.ContentTweakerVanillaConstants;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.ItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.TierReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.Sword")
@ZenRegister(loaders={"contenttweaker"})
public final class SwordItemBuilder
extends ItemBuilder<SwordItemBuilder> {
    private Integer attackDamageBase = null;
    private Float attackDamageSpeed = null;
    private TierReference tier = null;

    public SwordItemBuilder(BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        super(registrationManager);
    }

    @ZenCodeType.Method(value="baseAttackDamage")
    public SwordItemBuilder baseAttackDamage(int attackDamageBase) {
        this.attackDamageBase = attackDamageBase;
        return this;
    }

    @ZenCodeType.Method(value="attackSpeed")
    public SwordItemBuilder attackSpeed(float attackSpeed) {
        this.attackDamageSpeed = Float.valueOf(attackSpeed);
        return this;
    }

    @ZenCodeType.Method(value="tier")
    public SwordItemBuilder tier(TierReference tier) {
        this.tier = Objects.requireNonNull(tier);
        return this;
    }

    @Override
    public ObjectHolder<? extends Item> create(ResourceLocation name, Supplier<Item.Properties> builtProperties) {
        if (this.tier == null) {
            throw new IllegalStateException("Unable to create a sword item without a tier");
        }
        if (this.attackDamageBase == null) {
            throw new IllegalStateException("Unable to create a sword without a base attack damage");
        }
        if (this.attackDamageSpeed == null) {
            throw new IllegalStateException("Unable to create a sword item without attack speed");
        }
        return ObjectHolder.of(VanillaObjectTypes.ITEM, name, () -> new SwordItem((Tier)this.tier.get(), this.attackDamageBase.intValue(), this.attackDamageSpeed.floatValue(), (Item.Properties)builtProperties.get()));
    }

    @Override
    public void provideResources(ResourceLocation name, ResourceManager manager) {
        ResourceFragment cotAssets = manager.fragment(StandardResourceFragmentKeys.CONTENT_TWEAKER_ASSETS);
        ResourceLocation texture = new ResourceLocation(name.m_135827_(), "item/%s".formatted(name.m_135815_()));
        cotAssets.provideTemplated(PathHelper.texture(texture), ContentTweakerVanillaConstants.itemTemplate("katana"));
        cotAssets.provideFixed(PathHelper.itemModel(name), ItemModel.of(new ResourceLocation("item/handheld")).layer(0, texture), ItemModel.SERIALIZER);
        cotAssets.provideOrAlter(PathHelper.usLang(), Language::of, it -> it.item(name, "Custom Sword"), Language.SERIALIZER);
    }
}

