/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.builder.item;

import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import com.blamejared.contenttweaker.vanilla.api.zen.builder.item.ItemBuilder;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.TierReference;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.builder.vanilla.item.ToolBuilder")
@ZenRegister(loaders={"contenttweaker"})
public abstract class ToolItemBuilder<T extends ToolItemBuilder<T>>
extends ItemBuilder<T> {
    private Float attackDamageBase = null;
    private Float attackDamageSpeed = null;
    private TierReference tier = null;

    protected ToolItemBuilder(BiFunction<ObjectHolder<? extends Item>, Consumer<ResourceManager>, ItemReference> registrationManager) {
        super(registrationManager);
    }

    @ZenCodeType.Method(value="baseAttackDamage")
    public T baseAttackDamage(float attackDamageBase) {
        this.attackDamageBase = Float.valueOf(attackDamageBase);
        return this.self();
    }

    @ZenCodeType.Method(value="attackSpeed")
    public T attackSpeed(float attackSpeed) {
        this.attackDamageSpeed = Float.valueOf(attackSpeed);
        return this.self();
    }

    @ZenCodeType.Method(value="tier")
    public T tier(TierReference tier) {
        this.tier = Objects.requireNonNull(tier);
        return this.self();
    }

    @Override
    public final ObjectHolder<? extends Item> create(ResourceLocation name, Supplier<Item.Properties> builtProperties) {
        if (this.tier == null) {
            throw new IllegalStateException("Unable to create a tool item without a tier");
        }
        if (this.attackDamageBase == null) {
            throw new IllegalStateException("Unable to create a tool without a base attack damage");
        }
        if (this.attackDamageSpeed == null) {
            throw new IllegalStateException("Unable to create a tool item without attack speed");
        }
        return this.createTool(name, new ToolData(this.tier::get, this.attackDamageBase.floatValue(), this.attackDamageSpeed.floatValue()), builtProperties);
    }

    public abstract ObjectHolder<? extends Item> createTool(ResourceLocation var1, ToolData var2, Supplier<Item.Properties> var3);

    private T self() {
        return (T)((ToolItemBuilder)GenericUtil.uncheck((Object)this));
    }

    protected record ToolData(Supplier<Tier> tier, float baseAttackDamage, float attackSpeed) {
    }
}

