/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.object;

import com.blamejared.contenttweaker.core.api.util.ClassArchitect;
import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.ItemProperties;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.StandardItemProperties;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.object.vanilla.ItemReference")
@ZenRegister(loaders={"contenttweaker"})
public final class ItemReference
extends Reference<Item> {
    private static final ClassArchitect<ItemProperties> ITEM_PROPERTIES_ARCHITECT = ClassArchitect.of(ItemReference.class);
    public static final ItemReference AIR = ItemReference.of(new ResourceLocation("air"));

    private ItemReference(ResourceLocation id) {
        super(VanillaObjectTypes.ITEM, id);
    }

    @ZenCodeType.Method(value="of")
    public static ItemReference of(ResourceLocation id) {
        return new ItemReference(id);
    }

    @ZenCodeType.Getter(value="properties")
    public StandardItemProperties properties() {
        return this.findProperties(StandardItemProperties.class);
    }

    @ZenCodeType.Method(value="findProperties")
    public <T extends ItemProperties> T findProperties(Class<T> reifiedT) {
        return (T)((ItemProperties)ITEM_PROPERTIES_ARCHITECT.construct(reifiedT, this));
    }
}

