/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.api.zen.object.property;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.zen.object.SimpleReference;
import com.blamejared.contenttweaker.vanilla.api.ContentTweakerVanillaApi;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.zen.object.BlockReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.MaterialColorReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.BlockProperties;
import com.blamejared.contenttweaker.vanilla.api.zen.object.property.BlockPropertyFunctions;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.object.vanilla.property.StandardBlockProperties")
@ZenRegister(loaders={"contenttweaker"})
public final class StandardBlockProperties
extends BlockProperties {
    public StandardBlockProperties(BlockReference reference) {
        super(reference, "standard");
    }

    public SimpleReference<Material> material() {
        Material material = this.resolveProperties().material();
        return SimpleReference.of(VanillaObjectTypes.MATERIAL, this.nameOf(VanillaObjectTypes.MATERIAL, material));
    }

    public BlockPropertyFunctions.MaterialColorFinder materialColor() {
        return this.resolveProperties().materialColor().andThen(it -> this.nameOf(VanillaObjectTypes.MATERIAL_COLOR, it)).andThen(MaterialColorReference::of)::apply;
    }

    public boolean hasCollision() {
        return this.resolveProperties().hasCollision();
    }

    public SimpleReference<SoundType> soundType() {
        SoundType type = this.resolveProperties().soundType();
        return SimpleReference.of(VanillaObjectTypes.SOUND_TYPE, this.nameOf(VanillaObjectTypes.SOUND_TYPE, type));
    }

    public BlockPropertyFunctions.LightLevelComputer lightEmission() {
        return this.resolveProperties().lightEmission()::applyAsInt;
    }

    public float explosionResistance() {
        return this.resolve().m_7325_();
    }

    public float destroyTime() {
        return this.resolve().m_155943_();
    }

    public boolean requiresCorrectToolForDrops() {
        return this.resolveProperties().requiresCorrectToolForDrops();
    }

    public boolean isRandomlyTicking() {
        return this.resolveProperties().isRandomlyTicking();
    }

    public float friction() {
        return this.resolve().m_49958_();
    }

    public float speedFactor() {
        return this.resolve().m_49961_();
    }

    public float jumpFactor() {
        return this.resolve().m_49964_();
    }

    public ResourceLocation drops() {
        return this.resolve().m_60589_();
    }

    public boolean canOcclude() {
        return this.resolveProperties().canOcclude();
    }

    public boolean isAir() {
        return this.resolveProperties().isAir();
    }

    public boolean dynamicShape() {
        return this.resolve().m_49967_();
    }

    private VanillaAdapter resolveProperties() {
        return ContentTweakerVanillaApi.get().blockPropertiesAdapterOf(this.resolve());
    }

    private <T> ResourceLocation nameOf(ObjectType<T> type, T thing) {
        return ContentTweakerApi.get().registry().findResolver(type).nameOf(thing);
    }

    public static interface VanillaAdapter {
        public Material material();

        public Function<BlockState, MaterialColor> materialColor();

        public boolean hasCollision();

        public SoundType soundType();

        public ToIntFunction<BlockState> lightEmission();

        public boolean requiresCorrectToolForDrops();

        public boolean isRandomlyTicking();

        public boolean canOcclude();

        public boolean isAir();
    }
}

