/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.vanilla.zen.bracket;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.plugin.CustomBracketRegistration;
import com.blamejared.contenttweaker.core.api.zen.bracket.BracketHelper;
import com.blamejared.contenttweaker.core.api.zen.bracket.ReferenceBracketExpressionParser;
import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.contenttweaker.core.api.zen.object.SimpleReference;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.registry.CreativeTabRegistry;
import com.blamejared.contenttweaker.vanilla.api.zen.object.BlockReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.MaterialColorReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.TierReference;
import com.blamejared.contenttweaker.vanilla.zen.bracket.CreativeTabBracketExpressionParser;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Material;
import org.openzen.zenscript.parser.BracketExpressionParser;

public final class ContentTweakerVanillaBrackets {
    private static final Collection<ReferenceBracketData<?, ?>> BRACKETS = List.of(ContentTweakerVanillaBrackets.b("block", VanillaObjectTypes.BLOCK, null, new TypeToken<BlockReference>(){}, null, false), ContentTweakerVanillaBrackets.b("item", VanillaObjectTypes.ITEM, null, new TypeToken<ItemReference>(){}, null, false), ContentTweakerVanillaBrackets.b("material", VanillaObjectTypes.MATERIAL, null, new TypeToken<SimpleReference<Material>>(){}, null, true), ContentTweakerVanillaBrackets.b("materialcolor", VanillaObjectTypes.MATERIAL_COLOR, "material color", new TypeToken<MaterialColorReference>(){}, null, true), ContentTweakerVanillaBrackets.b("soundevent", VanillaObjectTypes.SOUND_EVENT, "sound event", new TypeToken<SimpleReference<SoundEvent>>(){}, null, true), ContentTweakerVanillaBrackets.b("soundtype", VanillaObjectTypes.SOUND_TYPE, "sound type", new TypeToken<SimpleReference<SoundType>>(){}, null, true), ContentTweakerVanillaBrackets.b("tooltier", VanillaObjectTypes.TIER, "tool tier", new TypeToken<TierReference>(){}, null, true));

    private ContentTweakerVanillaBrackets() {
    }

    public static void register(CustomBracketRegistration registration) {
        BRACKETS.forEach(data -> ContentTweakerVanillaBrackets.register(registration, data));
        registration.registerBracket("tab", (BracketExpressionParser)new CreativeTabBracketExpressionParser(), BracketHelper.dumpAllOf("tab", VanillaObjectTypes.CREATIVE_TAB, CreativeTabRegistry::toId));
    }

    private static <T, U extends Reference<T>> void register(CustomBracketRegistration registration, ReferenceBracketData<T, U> data) {
        String name = data.name();
        ObjectType<T> type = data.type();
        ReferenceBracketExpressionParser<T, U> parser = ReferenceBracketExpressionParser.of(data.format(), type, data.token());
        if (data.doDump()) {
            Function<ResourceLocation, String> converter = data.converter();
            Supplier<Stream<String>> dumper = converter != null ? BracketHelper.dumpAllOf(name, type, converter) : BracketHelper.dumpAllOf(name, type);
            registration.registerBracket(name, parser, dumper);
        } else {
            registration.registerBracket(name, parser);
        }
    }

    private static <T, U extends Reference<T>> ReferenceBracketData<T, U> b(String name, ObjectType<T> type, String friendlyName, TypeToken<U> token, Function<ResourceLocation, String> conv, boolean doDump) {
        String format = "Expected a " + (friendlyName == null ? name : friendlyName) + " in the form <" + name + ":modid:name>, but found <" + name + ":%s>";
        return new ReferenceBracketData<T, U>(name, type, format, token, conv, doDump);
    }

    private record ReferenceBracketData<T, U extends Reference<T>>(String name, ObjectType<T> type, String format, TypeToken<U> token, Function<ResourceLocation, String> converter, boolean doDump) {
    }
}

