/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRangeToggleButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.render.HackSimulationRenderer;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.inventory.SecurityStationMainMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SecurityStationInventoryScreen
extends AbstractPneumaticCraftContainerScreen<SecurityStationMainMenu, SecurityStationBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private WidgetAnimatedStat accessStat;
    private WidgetButtonExtended addUserButton;
    private Button rebootButton;
    private WidgetTextField sharedUserTextField;
    private List<WidgetButtonExtended> sharedUserList;
    private HackSimulationRenderer hackRenderer;
    private HackSimulation hackSimulation;
    private boolean reInitBG;

    public SecurityStationInventoryScreen(SecurityStationMainMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97727_ = 239;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.SECURITY_STATION.get()), -3112960, false);
        this.accessStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.sharedUsers", new Object[0]), new ItemStack((ItemLike)Items.f_42680_), -16755456, false);
        this.addUserButton = new WidgetButtonExtended(105, 12, 16, 16, "+", b -> {
            if (!this.sharedUserTextField.m_94155_().isEmpty()) {
                NetworkHandler.sendToServer(new PacketGuiButton("add:" + this.sharedUserTextField.m_94155_()));
                this.sharedUserTextField.m_94144_("");
            }
        });
        this.sharedUserTextField = new WidgetTextField(this.f_96547_, 20, 15, 80, 10);
        this.accessStat.addSubWidget((AbstractWidget)this.sharedUserTextField);
        this.accessStat.addSubWidget((AbstractWidget)this.addUserButton);
        this.accessStat.setMinimumExpandedDimensions(125, 40);
        this.rebootButton = new WidgetButtonExtended(this.f_97735_ + 110, this.f_97736_ + 17, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.reboot", new Object[0])).withTag("reboot");
        this.m_142416_((GuiEventListener)this.rebootButton);
        ((WidgetButtonExtended)this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.f_97735_ + 110, this.f_97736_ + 107, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.test", new Object[0])))).withTag("test");
        this.m_142416_((GuiEventListener)new WidgetRangeToggleButton(this.f_97735_ + 154, this.f_97736_ + 130, (IRangedTE)((Object)this.te)));
        this.updateUserList();
        this.initConnectionRendering();
    }

    private void initConnectionRendering() {
        this.hackRenderer = new HackSimulationRenderer(this.f_97735_ + 25, this.f_97736_ + 27, 18);
        this.hackSimulation = HackSimulation.dummySimulation();
        this.hackSimulation.wakeUp();
        for (int i = 0; i < ((SecurityStationBlockEntity)this.te).getPrimaryInventory().getSlots(); ++i) {
            this.hackSimulation.addNode(i, ((SecurityStationBlockEntity)this.te).getPrimaryInventory().getStackInSlot(i));
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SECURITY_STATION;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float opacity, int x, int y) {
        super.m_7286_(matrixStack, opacity, x, y);
        this.hackRenderer.render(matrixStack, this.hackSimulation, -14540033);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (this.reInitBG) {
            this.initConnectionRendering();
            this.reInitBG = false;
        }
        this.hackSimulation.tick();
        this.statusStat.setText(this.getStatusText());
        this.accessStat.setText(this.getAccessText());
        Object rebootButtonString = ((SecurityStationBlockEntity)this.te).getRebootTime() > 0 ? (((SecurityStationBlockEntity)this.te).getRebootTime() % 100 < 20 ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.rebooting", new Object[0]) : new TextComponent(PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((SecurityStationBlockEntity)this.te).getRebootTime(), false))) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.reboot", new Object[0]).m_130940_(ChatFormatting.RED);
        this.rebootButton.m_93666_((Component)rebootButtonString);
        this.addUserButton.f_93624_ = this.accessStat.isDoneExpanding();
        for (WidgetButtonExtended button : this.sharedUserList) {
            button.f_93623_ = this.accessStat.isDoneExpanding();
        }
        if (this.sharedUserList.size() != ((SecurityStationBlockEntity)this.te).sharedUsers.size()) {
            this.updateUserList();
        }
        this.rebootButton.f_93623_ = ((SecurityStationBlockEntity)this.te).getRebootTime() == 0;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.sharedUserTextField.m_93696_() && !this.sharedUserTextField.m_94155_().isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton("add:" + this.sharedUserTextField.m_94155_()));
            this.sharedUserTextField.m_94144_("");
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void addProblems(List<Component> text) {
        super.addProblems(text);
        if (((SecurityStationBlockEntity)this.te).getRebootTime() > 0) {
            text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.security_station.rebooting", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((SecurityStationBlockEntity)this.te).getRebootTime(), false)));
        } else if (((SecurityStationBlockEntity)this.te).isHacked()) {
            text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.security_station.hacked", new Object[0]));
        }
        if (!((SecurityStationBlockEntity)this.te).hasValidNetwork()) {
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.security_station.invalidNetwork", new Object[0]).m_130940_(ChatFormatting.WHITE));
            SecurityStationBlockEntity.EnumNetworkValidityProblem problem = ((SecurityStationBlockEntity)this.te).checkForNetworkValidity();
            if (problem != SecurityStationBlockEntity.EnumNetworkValidityProblem.NONE) {
                text.addAll(GuiUtils.xlateAndSplit(problem.getTranslationKey(), new Object[0]));
            }
        }
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.protection", new Object[0]).m_130940_(ChatFormatting.WHITE));
        if (((SecurityStationBlockEntity)this.te).getRebootTime() > 0) {
            text.add((Component)new TextComponent("  ").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.rebooting", new Object[0])).m_130940_(ChatFormatting.DARK_RED));
        } else if (((SecurityStationBlockEntity)this.te).isHacked()) {
            text.add((Component)new TextComponent("  ").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.hackedBy", new Object[0])).m_130940_(ChatFormatting.DARK_RED));
            for (GameProfile hacker : ((SecurityStationBlockEntity)this.te).hackedUsers) {
                text.add((Component)new TextComponent("  ").m_7220_((Component)Symbols.bullet()).m_130946_(hacker.getName()).m_130940_(ChatFormatting.RED));
            }
        } else {
            text.add((Component)new TextComponent("  ").m_7220_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.secure", new Object[0])).m_130940_(ChatFormatting.GREEN));
        }
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityLevel", new Object[0]).m_130940_(ChatFormatting.WHITE));
        text.add((Component)new TextComponent("  ").m_7220_((Component)new TextComponent("L" + ((SecurityStationBlockEntity)this.te).getSecurityLevel())).m_130940_(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.detectChance", new Object[0]).m_130940_(ChatFormatting.WHITE));
        text.add((Component)new TextComponent("  ").m_7220_((Component)new TextComponent(((SecurityStationBlockEntity)this.te).getDetectionChance() + "%")).m_130940_(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityRange", new Object[0]).m_130940_(ChatFormatting.WHITE));
        text.add((Component)new TextComponent("  ").m_7220_((Component)new TextComponent(((SecurityStationBlockEntity)this.te).getRange() * 2 + 1 + "m\u00b2")).m_130940_(ChatFormatting.BLACK));
        return text;
    }

    private List<Component> getAccessText() {
        ArrayList<Component> textList = new ArrayList<Component>();
        textList.add(TextComponent.f_131282_);
        textList.add(TextComponent.f_131282_);
        boolean first = true;
        List names = ((SecurityStationBlockEntity)this.te).sharedUsers.stream().map(GameProfile::getName).sorted().collect(Collectors.toList());
        for (String name : names) {
            Object str = first ? name + " \u2654" : name;
            textList.add((Component)Symbols.bullet().m_130946_((String)str).m_130940_(first ? ChatFormatting.YELLOW : ChatFormatting.WHITE));
            first = false;
        }
        return textList;
    }

    private void updateUserList() {
        if (this.sharedUserList != null) {
            for (WidgetButtonExtended button : this.sharedUserList) {
                this.accessStat.removeSubWidget((AbstractWidget)button);
            }
        }
        this.sharedUserList = new ArrayList<WidgetButtonExtended>();
        int n = 0;
        List names = ((SecurityStationBlockEntity)this.te).sharedUsers.stream().map(GameProfile::getName).sorted().collect(Collectors.toList());
        for (String name : names) {
            Objects.requireNonNull(this.f_96547_);
            WidgetButtonExtended button = new WidgetButtonExtended(24, 30 + n * (9 + 1), this.f_96547_.m_92895_(name), 8, TextComponent.f_131282_, b -> {}).setVisible(false).setInvisibleHoverColor(-2130771968).withTag("remove:" + name);
            button.setInvisibleHoverColor(-2130771968);
            button.setVisible(false);
            this.accessStat.addSubWidget((AbstractWidget)button);
            this.sharedUserList.add(button);
            button.f_93624_ = !name.equals(this.f_96541_.f_91074_.m_36316_().getName());
            ++n;
        }
    }

    public static void reinitConnectionRendering() {
        if (Minecraft.m_91087_().f_91080_ instanceof SecurityStationInventoryScreen) {
            ((SecurityStationInventoryScreen)Minecraft.m_91087_().f_91080_).reInitBG = true;
        }
    }
}

