/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorColors;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.GuiUtils;

public class ArmorColoringScreen
extends AbstractPneumaticCraftScreen {
    private boolean needSave = false;
    private final int[][] origColors = new int[4][SelectorType.values().length];
    private final int[][] colors = new int[4][SelectorType.values().length];
    private final List<SelectorButton> selectorButtons = new ArrayList<SelectorButton>();
    private final Map<ColorComponent, RGBSlider> rgbSliders = new EnumMap<ColorComponent, RGBSlider>(ColorComponent.class);
    private WidgetButtonExtended saveButton;
    private WidgetLabel scrollLabel;
    private static EquipmentSlot selectedSlot = EquipmentSlot.HEAD;
    private static SelectorType selectorType = SelectorType.PRIMARY;

    public ArmorColoringScreen() {
        super((Component)new TextComponent("Colors"));
        Player player = ClientUtils.getClientPlayer();
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = player.m_6844_(slot);
            int idx = slot.m_20749_();
            Item item = stack.m_41720_();
            if (!(item instanceof PneumaticArmorItem)) continue;
            PneumaticArmorItem armor = (PneumaticArmorItem)item;
            int n = armor.m_41121_(stack);
            this.colors[idx][0] = n;
            this.origColors[idx][0] = n;
            int n2 = armor.getSecondaryColor(stack);
            this.colors[idx][1] = n2;
            this.origColors[idx][1] = n2;
            int n3 = armor.getEyepieceColor(stack);
            this.colors[idx][2] = n3;
            this.origColors[idx][2] = n3;
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.xSize = this.f_96543_;
        this.ySize = this.f_96544_;
        this.selectorButtons.clear();
        for (EquipmentSlot equipmentSlot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (SelectorType type : SelectorType.values()) {
                this.selectorButtons.add(new SelectorButton(this, equipmentSlot, type));
            }
        }
        this.selectorButtons.forEach(x$0 -> {
            SelectorButton cfr_ignored_0 = (SelectorButton)this.m_142416_((GuiEventListener)x$0);
        });
        for (SelectorType selectorType : SelectorType.values()) {
            this.m_142416_((GuiEventListener)new WidgetLabel(87 + selectorType.xOffset, 30, (Component)new TextComponent(selectorType.label), -1).setAlignment(WidgetLabel.Alignment.CENTRE));
        }
        this.rgbSliders.clear();
        for (ColorComponent colorComponent : ColorComponent.values()) {
            this.rgbSliders.put(colorComponent, new RGBSlider(this, colorComponent, 43, 165 + colorComponent.yOffset, 128, 10, this.getCurrentColor() >> colorComponent.bitShift & 0xFF));
        }
        this.rgbSliders.values().forEach(x$0 -> {
            RGBSlider cfr_ignored_0 = (RGBSlider)this.m_142416_((GuiEventListener)x$0);
        });
        this.scrollLabel = new WidgetLabel(107, 210, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.colors.scrollWheel", new Object[0]), -6250336).setAlignment(WidgetLabel.Alignment.CENTRE);
        this.m_142416_((GuiEventListener)this.scrollLabel);
        this.scrollLabel.f_93624_ = false;
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(85, 130, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.copy", new Object[0]), b -> this.copyColorsToOtherPieces()).setTooltipKey("pneumaticcraft.armor.gui.misc.colors.copyTooltip", new Object[0]));
        this.saveButton = (WidgetButtonExtended)this.m_142416_((GuiEventListener)new WidgetButtonExtended(43, this.f_96544_ - 30, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.save", new Object[0]), b -> this.saveChanges()));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(88, this.f_96544_ - 30, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.reset", new Object[0]), b -> this.resetColors(Screen.m_96638_())).setTooltipKey("pneumaticcraft.armor.gui.misc.colors.resetTooltip", new Object[0]));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(133, this.f_96544_ - 30, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.cancel", new Object[0]), b -> this.m_7379_()));
        TranslatableComponent translatableComponent = PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.colors.showEnchantGlint", new Object[0]);
        int n = this.f_96543_ - this.f_96547_.m_92852_((FormattedText)translatableComponent) - 40;
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new WidgetCheckBox(n, this.f_96544_ - 9 - 10, -1, (Component)translatableComponent, b -> ConfigHelper.setShowEnchantGlint(b.checked)).setChecked((Boolean)ConfigHelper.client().armor.showEnchantGlint.get()));
    }

    private void setCurrentColor(int newCol) {
        this.colors[ArmorColoringScreen.selectedSlot.m_20749_()][ArmorColoringScreen.selectorType.ordinal()] = newCol;
    }

    private int getCurrentColor() {
        return this.colors[selectedSlot.m_20749_()][selectorType.ordinal()];
    }

    private void saveChanges() {
        ClientUtils.getClientPlayer().m_5496_((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), 1.0f, 1.0f);
        NetworkHandler.sendToServer(new PacketUpdateArmorColors());
        this.needSave = false;
    }

    private void copyColorsToOtherPieces() {
        for (int i = 0; i < this.colors.length; ++i) {
            if (i != selectedSlot.m_20749_()) {
                this.colors[i][ArmorColoringScreen.selectorType.ordinal()] = this.getCurrentColor();
            }
            this.updateClientSideArmor(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i));
        }
    }

    private void resetColors(boolean factorySettings) {
        for (int i = 0; i < this.colors.length; ++i) {
            for (SelectorType type : SelectorType.values()) {
                this.colors[i][type.ordinal()] = factorySettings ? type.defaultColor : this.origColors[i][type.ordinal()];
            }
            this.updateClientSideArmor(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i));
        }
        this.updateSliders();
        this.needSave = factorySettings;
    }

    private void updateClientSideArmor(EquipmentSlot slot) {
        Player player = ClientUtils.getClientPlayer();
        ItemStack stack = player.m_6844_(slot);
        Item item = stack.m_41720_();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem armor = (PneumaticArmorItem)item;
            armor.m_41115_(stack, this.colors[slot.m_20749_()][SelectorType.PRIMARY.ordinal()]);
            armor.setSecondaryColor(stack, this.colors[slot.m_20749_()][SelectorType.SECONDARY.ordinal()]);
            if (slot == EquipmentSlot.HEAD) {
                armor.setEyepieceColor(stack, this.colors[slot.m_20749_()][SelectorType.EYEPIECE.ordinal()]);
            }
        }
        for (EquipmentSlot slot2 : EquipmentSlot.values()) {
            HUDHandler.getInstance().updateOverlayColors(slot2);
        }
        this.selectorButtons.get((3 - slot.m_20749_()) * SelectorType.values().length).setRenderStacks(stack);
        this.needSave = true;
    }

    private void updateSliders() {
        for (ColorComponent color : ColorComponent.values()) {
            this.updateSlider(this.rgbSliders.get((Object)color), (this.getCurrentColor() & color.mask) >> color.bitShift);
        }
    }

    private void updateSlider(RGBSlider s, int val) {
        s.m_93611_(val);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.selectorButtons.forEach(b -> {
            b.f_93623_ = selectorType != b.selectorType || selectedSlot != b.slot;
        });
        this.saveButton.f_93623_ = this.needSave;
        this.scrollLabel.f_93624_ = this.rgbSliders.values().stream().anyMatch(AbstractWidget::m_198029_);
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, x, y, partialTicks);
        double scaleFactor = Minecraft.m_91087_().m_91268_().m_85449_();
        int scale = (int)((double)Minecraft.m_91087_().m_91268_().m_85444_() / (scaleFactor * 3.0));
        InventoryScreen.m_98850_((int)(this.f_96543_ * 2 / 3), (int)(this.f_96544_ * 3 / 4), (int)scale, (float)((float)(this.f_96543_ * 2) / 3.0f - (float)x), (float)((float)this.f_96544_ / 4.0f - (float)y), (LivingEntity)ClientUtils.getClientPlayer());
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (RGBSlider slider : this.rgbSliders.values()) {
            if (!slider.m_198029_()) continue;
            double val = Math.signum(delta);
            if (Screen.m_96638_()) {
                val *= 10.0;
            }
            int newVal = Mth.m_14045_((int)((int)((double)slider.getValueInt() + val)), (int)0, (int)255);
            if (slider.getValueInt() != newVal) {
                this.updateSlider(slider, newVal);
                slider.m_5697_();
            }
            return true;
        }
        return false;
    }

    public void m_7379_() {
        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)ArmorMainScreen.getInstance());
    }

    public void m_7861_() {
        if (this.needSave) {
            this.resetColors(false);
        }
        super.m_7861_();
    }

    public static enum SelectorType {
        PRIMARY(0, "1", -6908266),
        SECONDARY(22, "2", -4144960),
        EYEPIECE(44, "E", -16733696);

        private final int xOffset;
        private final String label;
        private final int defaultColor;

        private SelectorType(int xOffset, String label, int defaultColor) {
            this.xOffset = xOffset;
            this.label = label;
            this.defaultColor = defaultColor;
        }

        boolean showButton(EquipmentSlot slot) {
            return slot == EquipmentSlot.HEAD || this != EYEPIECE;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }
    }

    private static enum ColorComponent {
        RED(16, ChatFormatting.RED + "R: ", 0),
        GREEN(8, ChatFormatting.GREEN + "G: ", 15),
        BLUE(0, ChatFormatting.BLUE + "B: ", 30);

        private final int mask;
        private final int bitShift;
        private final String prefix;
        private final int yOffset;

        private ColorComponent(int bitShift, String prefix, int yOffset) {
            this.mask = 255 << bitShift;
            this.bitShift = bitShift;
            this.prefix = prefix;
            this.yOffset = yOffset;
        }
    }

    private static class SelectorButton
    extends WidgetButtonExtended {
        private final ArmorColoringScreen gui;
        private final EquipmentSlot slot;
        private final SelectorType selectorType;

        public SelectorButton(ArmorColoringScreen gui, EquipmentSlot slot, SelectorType selectorType) {
            super(78 + selectorType.xOffset, 41 + (3 - slot.m_20749_()) * 22, 18, 18, "", b -> {
                selectedSlot = slot;
                ArmorColoringScreen.selectorType = selectorType;
                gui.updateSliders();
            });
            this.gui = gui;
            this.slot = slot;
            this.selectorType = selectorType;
            this.f_93624_ = selectorType.showButton(slot) && PneumaticArmorItem.isPneumaticArmorPiece(ClientUtils.getClientPlayer(), slot);
            this.setHighlightWhenInactive(true);
            if (selectorType == SelectorType.PRIMARY) {
                this.setRenderStacks(ClientUtils.getClientPlayer().m_6844_(slot));
                this.setIconPosition(WidgetButtonExtended.IconPosition.LEFT);
            }
        }

        @Override
        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
            SelectorButton.m_93172_((PoseStack)matrixStack, (int)(this.f_93620_ + 3), (int)(this.f_93621_ + 3), (int)(this.f_93620_ + 14), (int)(this.f_93621_ + 14), (int)this.gui.colors[this.slot.m_20749_()][this.selectorType.ordinal()]);
            this.m_93154_(matrixStack, this.f_93620_ + 4, this.f_93620_ + 14, this.f_93621_ + 14, -14671840);
            this.m_93222_(matrixStack, this.f_93620_ + 14, this.f_93621_ + 3, this.f_93621_ + 14, -14671840);
        }
    }

    private static class RGBSlider
    extends PNCForgeSlider {
        private final ArmorColoringScreen gui;
        private final ColorComponent color;

        public RGBSlider(ArmorColoringScreen gui, ColorComponent color, int xPos, int yPos, int width, int height, double currentVal) {
            super(xPos, yPos, width, height, (Component)new TextComponent(color.prefix), TextComponent.f_131282_, 0.0, 255.0, currentVal, true, null);
            this.gui = gui;
            this.color = color;
        }

        public ColorComponent getColor() {
            return this.color;
        }

        @Override
        protected void m_5697_() {
            ColorComponent component = this.getColor();
            this.gui.setCurrentColor(this.gui.getCurrentColor() & ~component.mask | this.getValueInt() << component.bitShift);
            this.gui.updateClientSideArmor(selectedSlot);
            super.m_5697_();
        }

        @Override
        protected void m_7906_(PoseStack pPoseStack, Minecraft pMinecraft, int pMouseX, int pMouseY) {
            int xPos = this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8));
            int vOff = (this.m_198029_() ? 2 : 1) * 20;
            GuiUtils.drawContinuousTexturedBox((PoseStack)pPoseStack, (ResourceLocation)f_93617_, (int)xPos, (int)this.f_93621_, (int)0, (int)(46 + vOff), (int)8, (int)this.f_93619_, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.m_93252_());
        }
    }
}

