/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class WidgetButtonExtended
extends ExtendedButton
implements ITaggedWidget,
ITooltipProvider {
    private int iconSpacing = 18;
    private ItemStack[] renderedStacks;
    private ResourceLocation resLoc;
    private final List<Component> tooltipText = new ArrayList<Component>();
    private int invisibleHoverColor;
    private boolean thisVisible = true;
    private IconPosition iconPosition = IconPosition.MIDDLE;
    private String tag = null;
    private boolean renderStackSize = false;
    private boolean highlightInactive = false;

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, Component buttonText, Button.OnPress pressable) {
        super(startX, startY, xSize, ySize, buttonText, pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, Component buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText, Button.OnPress pressable) {
        super(startX, startY, xSize, ySize, (Component)new TextComponent(buttonText), pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize) {
        this(startX, startY, xSize, ySize, TextComponent.f_131282_, b -> {});
    }

    public WidgetButtonExtended withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public void m_5691_() {
        super.m_5691_();
        if (this.tag != null && !this.tag.isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton(this.tag));
        }
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public WidgetButtonExtended setVisible(boolean visible) {
        this.thisVisible = visible;
        return this;
    }

    public WidgetButtonExtended setInvisibleHoverColor(int color) {
        this.invisibleHoverColor = color;
        return this;
    }

    public WidgetButtonExtended setIconPosition(IconPosition iconPosition) {
        this.iconPosition = iconPosition;
        return this;
    }

    public WidgetButtonExtended setRenderStacks(ItemStack ... renderedStacks) {
        this.renderedStacks = renderedStacks;
        this.resLoc = null;
        return this;
    }

    public WidgetButtonExtended setRenderedIcon(ResourceLocation resLoc) {
        this.resLoc = resLoc;
        this.renderedStacks = null;
        return this;
    }

    public WidgetButtonExtended setIconSpacing(int spacing) {
        this.iconSpacing = spacing;
        return this;
    }

    public WidgetButtonExtended setTexture(Object texture) {
        if (texture instanceof ItemStack) {
            this.setRenderStacks((ItemStack)texture);
        } else if (texture instanceof ResourceLocation) {
            this.setRenderedIcon((ResourceLocation)texture);
        } else {
            throw new IllegalArgumentException("texture must be an ItemStack or ResourceLocation!");
        }
        return this;
    }

    public WidgetButtonExtended setTooltipKey(String key, Object ... params) {
        return this.setTooltipText(GuiUtils.xlateAndSplit(key, params));
    }

    public WidgetButtonExtended setTooltipText(Component tooltip) {
        return this.setTooltipText(Collections.singletonList(tooltip));
    }

    public WidgetButtonExtended setTooltipText(List<Component> tooltip) {
        this.tooltipText.clear();
        this.tooltipText.addAll(tooltip);
        return this;
    }

    public void setHighlightWhenInactive(boolean highlight) {
        this.highlightInactive = highlight;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shift) {
        curTip.addAll(this.tooltipText);
    }

    public boolean hasTooltip() {
        return !this.tooltipText.isEmpty();
    }

    public List<Component> getTooltip() {
        return this.tooltipText;
    }

    public int m_5711_() {
        return this.f_93618_;
    }

    public int m_93694_() {
        return this.f_93619_;
    }

    public void setRenderStackSize(boolean renderStackSize) {
        this.renderStackSize = renderStackSize;
    }

    public void m_6303_(PoseStack matrixStack, int x, int y, float partialTicks) {
        if (this.thisVisible && this.f_93624_ && !this.f_93623_ && this.highlightInactive) {
            Gui.m_93172_((PoseStack)matrixStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.m_5711_() + 1), (int)(this.f_93621_ + this.m_93694_() + 1), (int)-16711681);
        }
        if (this.thisVisible) {
            super.m_6303_(matrixStack, x, y, partialTicks);
        }
        if (this.f_93624_) {
            if (this.renderedStacks != null) {
                int startX = this.getIconX();
                for (int i = this.renderedStacks.length - 1; i >= 0; --i) {
                    Minecraft.m_91087_().m_91291_().m_115123_(this.renderedStacks[i], startX + i * this.iconSpacing, this.f_93621_ + 2);
                    if (!this.renderStackSize) continue;
                    Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, this.renderedStacks[i], startX + i * this.iconSpacing, this.f_93621_ + 2, null);
                }
            }
            if (this.resLoc != null) {
                RenderSystem.m_69478_();
                RenderSystem.m_69405_((int)770, (int)771);
                GuiUtils.drawTexture(matrixStack, this.resLoc, this.f_93620_ + this.f_93618_ / 2 - 8, this.f_93621_ + 2);
                RenderSystem.m_69461_();
            }
            if (this.f_93623_ && !this.thisVisible && x >= this.f_93620_ && y >= this.f_93621_ && x < this.f_93620_ + this.f_93618_ && y < this.f_93621_ + this.f_93619_) {
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)this.invisibleHoverColor);
            }
        }
    }

    private int getIconX() {
        return switch (this.iconPosition) {
            default -> throw new IncompatibleClassChangeError();
            case IconPosition.LEFT -> this.f_93620_ - 1 - 18 * this.renderedStacks.length;
            case IconPosition.RIGHT -> this.f_93620_ + this.f_93618_ + 1;
            case IconPosition.MIDDLE -> this.f_93620_ + this.f_93618_ / 2 - this.renderedStacks.length * 9 + 1;
        };
    }

    public static enum IconPosition {
        MIDDLE,
        LEFT,
        RIGHT;

    }
}

