/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WidgetTank
extends AbstractWidget
implements ITooltipProvider {
    private final IFluidTank tank;

    public WidgetTank(int x, int y, IFluidTank tank) {
        super(x, y, 16, 64, TextComponent.f_131282_);
        this.tank = tank;
    }

    public WidgetTank(int x, int y, FluidStack stack) {
        this(x, y, (IFluidTank)WidgetTank.makeTank(stack, 160000));
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack) {
        super(x, y, width, height, TextComponent.f_131282_);
        this.tank = WidgetTank.makeTank(stack, stack.getAmount());
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack, int capacity) {
        super(x, y, width, height, TextComponent.f_131282_);
        this.tank = WidgetTank.makeTank(stack, capacity);
    }

    private static FluidTank makeTank(FluidStack stack, int capacity) {
        FluidTank tank = new FluidTank(capacity);
        tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        return tank;
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        GuiUtils.drawFluid(matrixStack, new Rect2i(this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_), this.getFluid(), this.getTank());
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 300.0);
        for (int i = 3; i < this.f_93619_ - 1; i += 4) {
            int width = (i - 3) % 20 == 0 ? 16 : 2;
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)this.f_93620_, (int)(this.f_93621_ + i), (int)(this.f_93620_ + width), (int)(this.f_93621_ + i + 1), (int)-13684945);
        }
        matrixStack.m_85849_();
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTip, boolean shift) {
        Fluid fluid = this.tank.getFluid().getFluid();
        String amt = NumberFormat.getNumberInstance(Locale.getDefault()).format(this.tank.getFluidAmount());
        String capacity = NumberFormat.getNumberInstance(Locale.getDefault()).format(this.tank.getCapacity());
        curTip.add((Component)new TextComponent(amt + " / " + capacity + " mB"));
        if (fluid == Fluids.f_76191_ || this.tank.getCapacity() == 0 || this.tank.getFluidAmount() == 0) {
            curTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).m_130940_(ChatFormatting.GRAY));
        } else {
            curTip.add((Component)new FluidStack(fluid, this.tank.getFluidAmount()).getDisplayName().m_6881_().m_130940_(ChatFormatting.GRAY));
            curTip.add((Component)new TextComponent(ModNameCache.getModName(fluid)).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public void setFluid(FluidStack fluidStack) {
        if (fluidStack.getFluid() != this.tank.getFluid().getFluid()) {
            this.tank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        } else if (fluidStack.getAmount() > this.tank.getFluidAmount()) {
            this.tank.fill(new FluidStack(fluidStack.getFluid(), fluidStack.getAmount() - this.tank.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
        } else if (fluidStack.getAmount() < this.tank.getFluidAmount()) {
            this.tank.drain(this.tank.getFluidAmount() - fluidStack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

