/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.IKeyListener;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorColoringScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum HUDHandler implements IKeyListener
{
    INSTANCE;

    private int lastScaledWidth = -1;
    private int lastScaledHeight = -1;
    private long lastArmorInitSound;
    private long lastArmorInitCompleteSound;
    private boolean sentForceInitPacket = false;
    private final List<ArmorMessage> pendingMessages = new ArrayList<ArmorMessage>();

    public static HUDHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderHUD3d(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91066_.f_92062_ || mc.f_91080_ != null || !PneumaticArmorItem.isPneumaticArmorPiece((Player)player, EquipmentSlot.HEAD) || WidgetKeybindCheckBox.getCoreComponents() == null || !WidgetKeybindCheckBox.getCoreComponents().checked) {
            return;
        }
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer((Player)player);
        if (commonArmorHandler.getArmorPressure(EquipmentSlot.HEAD) > 0.0f) {
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                if (!commonArmorHandler.isArmorReady(slot)) continue;
                GlStateManager.m_84110_();
                List<IArmorUpgradeClientHandler<?>> clientHandlers = ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot);
                for (int i = 0; i < clientHandlers.size(); ++i) {
                    if (!commonArmorHandler.isUpgradeInserted(slot, i) || !WidgetKeybindCheckBox.forUpgrade(clientHandlers.get((int)i)).checked) continue;
                    clientHandlers.get(i).render3D(poseStack, (MultiBufferSource)buffer, event.getPartialTick());
                }
                GlStateManager.m_84109_();
            }
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            Player player = event.player;
            if (player == mc.f_91074_ && player.f_19853_.f_46443_) {
                boolean anyArmorEquipped = false;
                CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer();
                for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    if (!PneumaticArmorItem.isPneumaticArmorPiece(player, slot)) continue;
                    this.tickArmorPiece((Player)mc.f_91074_, slot, comHudHandler);
                    anyArmorEquipped = true;
                }
                if (anyArmorEquipped) {
                    this.ensureArmorInit(player, comHudHandler);
                    this.pendingMessages.forEach(ArmorMessage::tick);
                    this.pendingMessages.removeIf(message -> message == null || message.isExpired());
                } else {
                    this.pendingMessages.clear();
                    this.sentForceInitPacket = false;
                }
            }
        }
    }

    private void ensureArmorInit(Player player, CommonArmorHandler commonArmorHandler) {
        if (!PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.HEAD) && !this.sentForceInitPacket) {
            boolean state = WidgetKeybindCheckBox.getCoreComponents().checked;
            if (state) {
                commonArmorHandler.setUpgradeEnabled(EquipmentSlot.HEAD, (byte)0, true);
                NetworkHandler.sendToServer(new PacketToggleArmorFeature(EquipmentSlot.HEAD, 0, true));
            }
            this.sentForceInitPacket = true;
        }
    }

    private void tickArmorPiece(Player player, EquipmentSlot slot, CommonArmorHandler commonArmorHandler) {
        boolean armorEnabled = WidgetKeybindCheckBox.getCoreComponents().checked;
        List<IArmorUpgradeHandler<?>> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        List<IArmorUpgradeClientHandler<?>> clientHandlers = ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot);
        ItemStack armorStack = player.m_6844_(slot);
        int ticksSinceEquipped = commonArmorHandler.getTicksSinceEquipped(slot);
        int startupTime = commonArmorHandler.getStartupTime(slot);
        Component itemName = armorStack.m_41786_();
        if (ticksSinceEquipped > startupTime && armorEnabled) {
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                if (!commonArmorHandler.isUpgradeInserted(slot, i)) continue;
                IArmorUpgradeClientHandler<?> clientHandler = clientHandlers.get(i);
                if (!clientHandler.isToggleable() || commonArmorHandler.isUpgradeEnabled(slot, i)) {
                    IGuiAnimatedStat stat = clientHandler.getAnimatedStat();
                    if (stat != null) {
                        IArmorUpgradeHandler<?> upgradeHandler = upgradeHandlers.get(i);
                        if (commonArmorHandler.getArmorPressure(slot) > upgradeHandler.getMinimumPressure()) {
                            stat.openStat();
                        } else {
                            stat.closeStat();
                        }
                        stat.tickWidget();
                    }
                    clientHandler.tickClient(commonArmorHandler);
                }
                clientHandler.tickClient(commonArmorHandler, commonArmorHandler.isUpgradeEnabled(slot, i));
            }
        } else if (ticksSinceEquipped == startupTime) {
            this.playArmorInitCompleteSound(player);
            this.addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.initComplete", itemName), 50, 0x7000AA00));
        } else if (ticksSinceEquipped == 0 && WidgetKeybindCheckBox.getCoreComponents().checked) {
            for (IArmorUpgradeClientHandler<?> handler : ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot)) {
                handler.reset();
            }
            ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting> features = new ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting>();
            for (byte idx = 0; idx < upgradeHandlers.size(); idx = (byte)(idx + 1)) {
                boolean state = armorEnabled && WidgetKeybindCheckBox.forUpgrade(upgradeHandlers.get((int)idx)).checked;
                commonArmorHandler.setUpgradeEnabled(slot, idx, state);
                features.add(new PacketToggleArmorFeatureBulk.FeatureSetting(slot, idx, state));
            }
            NetworkHandler.sendToServer(new PacketToggleArmorFeatureBulk(features));
        } else if (ticksSinceEquipped == 1) {
            this.playArmorInitSound(player, 0.5f);
            this.addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.initStarted", itemName), 50, 0x7000AA00));
        } else {
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                if (ticksSinceEquipped != startupTime / (upgradeHandlers.size() + 2) * (i + 1)) continue;
                this.playArmorInitSound(player, 0.5f + (float)(i + 1) / (float)(upgradeHandlers.size() + 2) * 0.5f);
                boolean upgradeEnabled = commonArmorHandler.isUpgradeInserted(slot, i);
                MutableComponent message = PneumaticCraftUtils.xlate(upgradeHandlers.get(i).getTranslationKey(), new Object[0]).m_130946_(upgradeEnabled ? " installed" : " not installed");
                this.addMessage(new ArmorMessage((Component)message, 80, upgradeEnabled ? 0x7000AA00 : 1895792640));
            }
        }
    }

    private void playArmorInitSound(Player player, float pitch) {
        long when = player.f_19853_.m_46467_();
        if (when - this.lastArmorInitSound >= 30L) {
            player.m_6330_((SoundEvent)ModSounds.HUD_INIT.get(), SoundSource.PLAYERS, 0.2f, pitch);
        }
        this.lastArmorInitSound = when;
    }

    private void playArmorInitCompleteSound(Player player) {
        long when = player.f_19853_.m_46467_();
        if (when - this.lastArmorInitCompleteSound >= 30L) {
            player.m_6330_((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
        }
        this.lastArmorInitCompleteSound = when;
    }

    public void addFeatureToggleMessage(String key, boolean enabled) {
        this.addMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message." + (enabled ? "enable" : "disable") + "Setting", PneumaticCraftUtils.xlate(key, new Object[0])), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addFeatureToggleMessage(String key, String subKey, boolean enabled) {
        MutableComponent msg = PneumaticCraftUtils.xlate(key, new Object[0]).m_130946_(": ").m_7220_((Component)PneumaticCraftUtils.xlate(subKey, new Object[0]));
        this.addMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message." + (enabled ? "enable" : "disable") + "Setting", msg), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addMessage(Component title, List<Component> message, int duration, int backColor) {
        this.addMessage(new ArmorMessage(title, message, duration, backColor));
    }

    public void addMessage(ArmorMessage message) {
        if (this.pendingMessages.size() > 0) {
            message.setDependingMessage(this.pendingMessages.get(this.pendingMessages.size() - 1).getStat());
        }
        this.pendingMessages.add(message);
    }

    @Override
    public void handleInput(KeyMapping key) {
        if (Minecraft.m_91087_().m_91302_()) {
            ArmorUpgradeClientRegistry.getInstance().getTriggeredHandler(key).ifPresent(h -> h.onTriggered(CommonArmorHandler.getHandlerForPlayer()));
        }
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        ArmorUpgradeClientRegistry c = ArmorUpgradeClientRegistry.getInstance();
        boolean isCaptured = c.getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class).scroll(event);
        if (!isCaptured) {
            isCaptured = c.getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).scroll(event);
        }
        if (isCaptured) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleResolutionChange(ScreenEvent.InitScreenEvent event) {
        Window mw;
        Screen gui = event.getScreen();
        if (gui.getMinecraft().f_91073_ != null && ((mw = gui.getMinecraft().m_91268_()).m_85445_() != this.lastScaledWidth || mw.m_85446_() != this.lastScaledHeight)) {
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                for (IArmorUpgradeClientHandler<?> handler : ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot)) {
                    handler.onResolutionChanged();
                }
            }
            this.lastScaledWidth = mw.m_85445_();
            this.lastScaledHeight = mw.m_85446_();
        }
    }

    public int getStatOverlayColor() {
        int n;
        ItemStack stack = ClientUtils.getClientPlayer().m_6844_(EquipmentSlot.HEAD);
        Item item = stack.m_41720_();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem helmet = (PneumaticArmorItem)item;
            n = helmet.getEyepieceColor(stack);
        } else {
            n = ArmorColoringScreen.SelectorType.EYEPIECE.getDefaultColor();
        }
        int eyepieceColor = n;
        return eyepieceColor & 0xFFFFFF | 0x30000000;
    }

    public void updateOverlayColors(EquipmentSlot slot) {
        int color = this.getStatOverlayColor();
        ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot).forEach(clientHandler -> clientHandler.setOverlayColor(color));
    }

    public void renderMessages(PoseStack poseStack, float partialTicks) {
        this.pendingMessages.forEach(message -> message.renderMessage(poseStack, partialTicks));
    }
}

