/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrackerBlacklistManager {
    private static final Set<ResourceLocation> ENERGY_BLACKLIST = Sets.newHashSet();
    private static final Set<ResourceLocation> INVENTORY_BLACKLIST = Sets.newHashSet();
    private static final Set<ResourceLocation> FLUID_BLACKLIST = Sets.newHashSet();

    public static void addEnergyTEToBlacklist(BlockEntity te, Throwable e) {
        TrackerBlacklistManager.addEntry(ENERGY_BLACKLIST, te, e);
    }

    public static void addInventoryTEToBlacklist(BlockEntity te, Throwable e) {
        TrackerBlacklistManager.addEntry(INVENTORY_BLACKLIST, te, e);
    }

    public static void addFluidTEToBlacklist(BlockEntity te, Throwable e) {
        TrackerBlacklistManager.addEntry(FLUID_BLACKLIST, te, e);
    }

    private static void addEntry(Set<ResourceLocation> blacklist, BlockEntity te, Throwable e) {
        if (!blacklist.contains(TrackerBlacklistManager.keyFor(te))) {
            e.printStackTrace();
            String title = Objects.requireNonNull(Objects.requireNonNull(te.m_58904_()).m_8055_(te.m_58899_()).m_60734_().getRegistryName()).toString();
            HUDHandler.getInstance().addMessage((Component)new TextComponent("Block tracking failed for " + title + "!"), (List<Component>)ImmutableList.of((Object)new TextComponent("A stacktrace can be found in the log.")), 80, -65536);
            blacklist.add(TrackerBlacklistManager.keyFor(te));
        }
    }

    static boolean isEnergyBlacklisted(BlockEntity te) {
        return ENERGY_BLACKLIST.contains(TrackerBlacklistManager.keyFor(te));
    }

    static boolean isInventoryBlacklisted(BlockEntity te) {
        return INVENTORY_BLACKLIST.contains(TrackerBlacklistManager.keyFor(te));
    }

    static boolean isFluidBlacklisted(BlockEntity te) {
        return FLUID_BLACKLIST.contains(TrackerBlacklistManager.keyFor(te));
    }

    private static ResourceLocation keyFor(BlockEntity te) {
        return te.m_58903_().getRegistryName();
    }
}

