/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class MovingSoundJetBoots
extends AbstractTickableSoundInstance {
    private static final int END_TICKS = 20;
    private static final Vec3 IDLE_VEC = new Vec3(0.0, -0.5, 0.0);
    private final Player player;
    private float targetPitch;
    private int endTimer = Integer.MAX_VALUE;

    public MovingSoundJetBoots(Player player) {
        super((SoundEvent)ModSounds.LEAKING_GAS_LOW.get(), SoundSource.NEUTRAL);
        this.player = player;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.targetPitch = 0.7f;
        this.f_119574_ = 0.5f;
        this.f_119573_ = this.volumeFromConfig(JetBootsStateTracker.getClientTracker().getJetBootsState(player).isBuilderMode());
        player.m_6034_(player.m_20185_(), player.m_20186_() + 0.1, player.m_20189_());
    }

    public void m_7788_() {
        if (!this.player.m_6084_()) {
            return;
        }
        JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getClientTracker().getJetBootsState(this.player);
        if (this.endTimer == Integer.MAX_VALUE && (!jbState.isEnabled() || !jbState.isActive() && (this.player.m_20096_() || this.player.m_21255_()))) {
            this.endTimer = 20;
        }
        if (this.endTimer <= 20) {
            this.endTimer = this.player.m_20096_() || !jbState.isActive() ? --this.endTimer : Integer.MAX_VALUE;
        }
        this.f_119575_ = (float)this.player.m_20185_();
        this.f_119576_ = (float)this.player.m_20186_();
        this.f_119577_ = (float)this.player.m_20189_();
        if (this.endTimer > 0 && this.endTimer <= 20) {
            this.targetPitch = 0.5f;
            this.f_119573_ = this.volumeFromConfig(jbState.isBuilderMode()) - (float)(20 - this.endTimer) / 50.0f;
        } else {
            if (jbState.isActive()) {
                double vel = this.player.m_20184_().m_82553_();
                this.targetPitch = 0.9f + (float)vel / 15.0f;
                this.f_119573_ = this.volumeFromConfig(jbState.isBuilderMode()) + (float)vel / 15.0f;
            } else {
                this.targetPitch = 0.9f;
                this.f_119573_ = this.volumeFromConfig(jbState.isBuilderMode()) * 0.8f;
            }
            this.handleParticles(jbState.isActive(), jbState.isBuilderMode());
        }
        this.f_119574_ += (this.targetPitch - this.f_119574_) / 10.0f;
        if (this.player.m_20069_()) {
            this.f_119574_ *= 0.75f;
            this.f_119573_ *= 0.5f;
        }
    }

    public boolean m_7801_() {
        return !this.player.m_6084_() || this.endTimer <= 0;
    }

    private void handleParticles(boolean jetBootsActive, boolean builderMode) {
        int distThresholdSq = ClientUtils.getRenderDistanceThresholdSq();
        if ((jetBootsActive || (this.player.f_19853_.m_46467_() & 3L) == 0L || !ClientUtils.isFirstPersonCamera()) && this.player.m_20280_((Entity)ClientUtils.getClientPlayer()) < (double)distThresholdSq) {
            Vec3 jetVec;
            int nParticles = jetBootsActive ? 3 : 1;
            Vec3 vec3 = jetVec = jetBootsActive && !builderMode ? this.player.m_20154_().m_82490_(-0.5) : IDLE_VEC;
            Vec3 feet = jetBootsActive && !builderMode ? this.player.m_20182_().m_82549_(this.player.m_20154_().m_82490_(this.player == ClientUtils.getClientPlayer() ? -4.0 : -2.0)) : this.player.m_20182_().m_82520_(0.0, -0.25, 0.0);
            for (int i = 0; i < nParticles; ++i) {
                this.player.f_19853_.m_7106_((ParticleOptions)AirParticleData.DENSE, feet.f_82479_, feet.f_82480_, feet.f_82481_, jetVec.f_82479_, jetVec.f_82480_, jetVec.f_82481_);
            }
        }
    }

    private float volumeFromConfig(boolean builderMode) {
        return builderMode ? ((Double)ConfigHelper.client().sound.jetbootsVolumeBuilderMode.get()).floatValue() : ((Double)ConfigHelper.client().sound.jetbootsVolume.get()).floatValue();
    }
}

