/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.Comparator;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class ChunkPositionSorter
implements Comparator<BlockPos> {
    private static final double EPSILON = 0.01;
    private final double x;
    private final double y;
    private final double z;
    private final IBlockOrdered.Ordering order;

    ChunkPositionSorter(IDroneBase entity) {
        this(entity, IBlockOrdered.Ordering.CLOSEST);
    }

    ChunkPositionSorter(IDroneBase entity, IBlockOrdered.Ordering order) {
        Vec3 vec = entity.getDronePos();
        this.x = Math.floor(vec.f_82479_) + 0.5;
        this.y = Math.floor(vec.f_82480_) + 0.5;
        this.z = Math.floor(vec.f_82481_) + 0.5;
        this.order = order;
    }

    public ChunkPositionSorter(double x, double y, double z, IBlockOrdered.Ordering order) {
        this.order = order;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public int compare(BlockPos c1, BlockPos c2) {
        if (this.order != IBlockOrdered.Ordering.CLOSEST && c1.m_123342_() != c2.m_123342_()) {
            return this.order == IBlockOrdered.Ordering.HIGH_TO_LOW ? c2.m_123342_() - c1.m_123342_() : c1.m_123342_() - c2.m_123342_();
        }
        double d = PneumaticCraftUtils.distBetweenSq(c1.m_123341_(), c1.m_123342_(), c1.m_123343_(), this.x, this.y, this.z) - PneumaticCraftUtils.distBetweenSq(c2.m_123341_(), c2.m_123342_(), c2.m_123343_(), this.x, this.y, this.z);
        if (Math.abs(d) < 0.01) {
            return c1.compareTo((Vec3i)c2);
        }
        return d < 0.0 ? -1 : 1;
    }
}

