/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetExternalProgram;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DroneAIExternalProgram
extends DroneAIBlockInteraction<ProgWidgetExternalProgram> {
    private final DroneAIManager subAI;
    private final DroneAIManager mainAI;
    private final Set<BlockPos> traversedPositions = new HashSet<BlockPos>();
    private int curSlot;
    private CompoundTag curProgramTag;

    public DroneAIExternalProgram(IDroneBase drone, DroneAIManager mainAI, ProgWidgetExternalProgram widget) {
        super(drone, widget);
        this.mainAI = mainAI;
        this.subAI = new DroneAIManager(drone, new ArrayList<IProgWidget>());
    }

    @Override
    public boolean m_8036_() {
        if (super.m_8036_()) {
            this.traversedPositions.clear();
            return true;
        }
        return false;
    }

    @Override
    protected boolean moveToPositions() {
        return false;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.traversedPositions.add(pos)) {
            this.curSlot = 0;
            BlockEntity te = this.drone.world().m_7702_(pos);
            return te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return IOHelper.getInventoryForTE(this.drone.world().m_7702_(pos)).map(this::handleInv).orElse(false);
    }

    private boolean handleInv(IItemHandler inv) {
        if (this.curProgramTag != null) {
            if (this.curSlot < inv.getSlots()) {
                ItemStack stack = inv.getStackInSlot(this.curSlot);
                if (this.curProgramTag.equals((Object)stack.m_41783_())) {
                    this.subAI.onUpdateTasks();
                    if (this.subAI.isIdling() || this.isRunningSameProgram(this.subAI.getCurrentGoal())) {
                        this.curProgramTag = null;
                        ++this.curSlot;
                    }
                } else {
                    this.curProgramTag = null;
                    this.subAI.setWidgets(new ArrayList<IProgWidget>());
                    this.drone.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(new PacketSyncDroneEntityProgWidgets(this.drone), p));
                }
            }
            return true;
        }
        while (this.curSlot < inv.getSlots()) {
            IProgrammable programmable;
            ItemStack stack = inv.getStackInSlot(this.curSlot);
            Item item = stack.m_41720_();
            if (item instanceof IProgrammable && (programmable = (IProgrammable)item).canProgram(stack) && programmable.usesPieces(stack)) {
                List<IProgWidget> widgets = ProgrammerBlockEntity.getProgWidgets(stack);
                ProgrammerBlockEntity.updatePuzzleConnections(widgets);
                boolean areWidgetsValid = widgets.stream().allMatch(widget -> this.drone.isProgramApplicable(widget.getType()));
                if (areWidgetsValid) {
                    if (((ProgWidgetExternalProgram)this.progWidget).shareVariables) {
                        this.mainAI.connectVariables(this.subAI);
                    }
                    this.subAI.getDrone().getAIManager().setLabel("Main");
                    this.subAI.setWidgets(widgets);
                    this.drone.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(new PacketSyncDroneEntityProgWidgets(this.drone), p));
                    this.curProgramTag = stack.m_41783_();
                    if (!this.subAI.isIdling()) {
                        return true;
                    }
                }
            }
            ++this.curSlot;
        }
        this.abort();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRunningSameProgram(Goal ai) {
        if (!(ai instanceof DroneAIExternalProgram)) return false;
        DroneAIExternalProgram ext = (DroneAIExternalProgram)ai;
        if (!this.curProgramTag.equals((Object)ext.curProgramTag)) return false;
        return true;
    }

    public DroneAIManager getRunningAI() {
        return this.subAI;
    }
}

