/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DroneEntityAIInventoryExport
extends DroneAIImExBase<ProgWidgetInventoryBase> {
    public DroneEntityAIInventoryExport(IDroneBase drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.export(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.export(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    private boolean export(BlockPos pos, boolean simulate) {
        BlockEntity te = this.drone.world().m_7702_(pos);
        if (te != null) {
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (droneStack.m_41619_()) continue;
                if (((ProgWidgetInventoryBase)this.progWidget).isItemValidForFilters(droneStack)) {
                    for (int side = 0; side < 6; ++side) {
                        if (!((ProgWidgetInventoryBase)this.progWidget).getSides()[side]) continue;
                        droneStack = droneStack.m_41777_();
                        int oldCount = droneStack.m_41613_();
                        if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                            droneStack.m_41764_(Math.min(droneStack.m_41613_(), this.getRemainingCount()));
                        }
                        ItemStack remainder = IOHelper.insert(te, droneStack.m_41777_(), Direction.m_122376_((int)side), simulate);
                        int stackSize = this.drone.getInv().getStackInSlot(i).m_41613_() - (remainder.m_41619_() ? droneStack.m_41613_() : droneStack.m_41613_() - remainder.m_41613_());
                        droneStack.m_41764_(stackSize);
                        int exportedItems = oldCount - stackSize;
                        if (!simulate) {
                            this.drone.getInv().setStackInSlot(i, stackSize > 0 ? droneStack : ItemStack.f_41583_);
                            this.decreaseCount(exportedItems);
                        }
                        if (!simulate || exportedItems <= 0) continue;
                        return true;
                    }
                    if (droneStack.m_41619_() && !simulate) {
                        this.drone.addAirToDrone(-10);
                        continue;
                    }
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryExport.debug.filledToMax", pos);
                    continue;
                }
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryExport.debug.stackdoesntPassFilter", pos);
            }
        } else {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventory.debug.noInventory", pos);
        }
        return false;
    }
}

