/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.drone.AmadronRetrievalEvent;
import me.desht.pneumaticcraft.api.drone.DroneSuicideEvent;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.entity.drone.AmadroneEntity;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.ServerLifecycleHooks;

public class AmadronEventListener {
    private static long reshuffleCounter = 0L;

    @SubscribeEvent
    public void onDroneSuicide(DroneSuicideEvent event) {
        if (event.drone instanceof AmadroneEntity) {
            AmadroneEntity drone = (AmadroneEntity)event.drone;
            AmadronRecipe offer = AmadronOfferManager.getInstance().getOffer(drone.getHandlingOffer());
            if (offer != null) {
                offer.getInput().accept(itemStack -> {
                    int i;
                    int requiredCount = offer.getInput().getAmount() * drone.getOfferTimes();
                    for (i = 0; i < drone.getInv().getSlots(); ++i) {
                        requiredCount -= drone.getInv().getStackInSlot(i).m_41613_();
                    }
                    if (requiredCount <= 0) {
                        for (i = 0; i < drone.getInv().getSlots(); ++i) {
                            drone.getInv().setStackInSlot(i, ItemStack.f_41583_);
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                    } else {
                        this.onAmadronFailure(drone, offer);
                    }
                }, fluidStack -> {
                    int requiredCount = offer.getInput().getAmount() * drone.getOfferTimes();
                    if (drone.getFluidTank().getFluidAmount() >= requiredCount) {
                        MinecraftForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                    } else {
                        this.onAmadronFailure(drone, offer);
                    }
                });
            }
        }
    }

    private void onAmadronFailure(AmadroneEntity drone, AmadronRecipe offer) {
        if (offer instanceof AmadronPlayerOffer || offer.getMaxStock() >= 0) {
            offer.setStock(offer.getStock() + drone.getOfferTimes());
            if (offer instanceof AmadronPlayerOffer) {
                AmadronPlayerOffers.save();
            }
            NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(offer.m_6423_(), offer.getStock()));
        }
    }

    @SubscribeEvent
    public void onAmadronSuccess(AmadronRetrievalEvent event) {
        AmadroneEntity drone = (AmadroneEntity)event.drone;
        AmadronRecipe offer = AmadronOfferManager.getInstance().getOffer(drone.getHandlingOffer());
        AmadronPlayerOffer playerOffer = this.getPlayerOffer(offer);
        if (playerOffer == null) {
            this.doDelivery(drone, offer);
        } else {
            if (drone.getAmadronAction() == AmadroneEntity.AmadronAction.TAKING_PAYMENT) {
                if (offer instanceof AmadronPlayerOffer) {
                    ((AmadronPlayerOffer)offer).addPayment(drone.getOfferTimes());
                }
                playerOffer.onTrade(drone.getOfferTimes(), drone.getBuyingPlayer());
                this.doDelivery(drone, offer);
            } else if (drone.getAmadronAction() == AmadroneEntity.AmadronAction.RESTOCKING) {
                playerOffer.setStock(playerOffer.getStock() + drone.getOfferTimes());
                NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(playerOffer.m_6423_(), playerOffer.getStock()));
                playerOffer.notifyRestock();
            }
            AmadronPlayerOffers.save();
        }
    }

    private void doDelivery(AmadroneEntity drone, AmadronRecipe offer) {
        ItemStack usedTablet = drone.getUsedTablet();
        offer.getOutput().accept(itemStack -> {
            GlobalPos itemPos = AmadronTabletItem.getItemProvidingLocation(usedTablet);
            if (itemPos != null) {
                ItemStack stack;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int toDeliver = itemStack.m_41613_() * drone.getOfferTimes(); toDeliver > 0; toDeliver -= stack.m_41613_()) {
                    stack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)Math.min(toDeliver, itemStack.m_41741_()));
                    stacks.add(stack);
                }
                DroneRegistry.getInstance().deliverItemsAmazonStyle(itemPos, stacks.toArray(new ItemStack[0]));
            }
        }, fluidStack -> {
            GlobalPos fluidPos = AmadronTabletItem.getFluidProvidingLocation(usedTablet);
            if (fluidPos != null) {
                FluidStack offeringFluid = fluidStack.copy();
                offeringFluid.setAmount(offeringFluid.getAmount() * drone.getOfferTimes());
                DroneRegistry.getInstance().deliverFluidAmazonStyle(fluidPos, offeringFluid);
            }
        });
    }

    @SubscribeEvent
    public void amadronHousekeeping(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerLevel overWorld;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (reshuffleCounter++ >= (long)((Integer)ConfigHelper.common().amadron.reshuffleInterval.get()).intValue() && !this.anyPlayerUsingAmadron(server)) {
                AmadronOfferManager.getInstance().compileActiveOffersList();
                reshuffleCounter = 0L;
            }
            if (server.m_129921_() % 600 == 0) {
                AmadronOfferManager.getInstance().tryRestockPlayerOffers();
            }
            if ((overWorld = server.m_129880_(Level.f_46428_)) != null) {
                AmadronOfferManager.getInstance().checkForFullRebuild((Level)overWorld);
            }
        }
    }

    private boolean anyPlayerUsingAmadron(MinecraftServer server) {
        return server.m_6846_().m_11314_().stream().anyMatch(player -> player.f_36096_ instanceof AmadronMenu);
    }

    private AmadronPlayerOffer getPlayerOffer(AmadronRecipe offer) {
        AmadronRecipe o = AmadronOfferManager.getInstance().getOffer(AmadronPlayerOffer.getReversedId(offer.m_6423_()));
        return o instanceof AmadronPlayerOffer ? (AmadronPlayerOffer)o : null;
    }
}

