/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.KeroseneLampBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KeroseneLampBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_NS = VoxelShapeUtils.or(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0), Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.m_49796_((double)11.5, (double)0.0, (double)7.0, (double)12.5, (double)10.0, (double)9.0), Block.m_49796_((double)11.0, (double)0.0, (double)7.0, (double)12.0, (double)1.0, (double)9.0), Block.m_49796_((double)11.0, (double)9.0, (double)7.0, (double)12.0, (double)10.0, (double)9.0), Block.m_49796_((double)4.0, (double)0.0, (double)7.0, (double)5.0, (double)1.0, (double)9.0), Block.m_49796_((double)4.0, (double)9.0, (double)7.0, (double)5.0, (double)10.0, (double)9.0), Block.m_49796_((double)3.5, (double)0.0, (double)7.0, (double)4.5, (double)10.0, (double)9.0), Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0));
    private static final VoxelShape SHAPE_EW = VoxelShapeUtils.rotateY(SHAPE_NS, 90);
    public static final EnumProperty<Direction> CONNECTED = EnumProperty.m_61587_((String)"connected", Direction.class);
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");

    public KeroseneLampBlock() {
        super(ModBlocks.defaultProps().m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.getRotation(state).m_122434_() == Direction.Axis.Z ? SHAPE_NS : SHAPE_EW;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONNECTED, LIT});
    }

    @Override
    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return state == null ? null : (BlockState)state.m_61124_(CONNECTED, (Comparable)this.getConnectedDirection((LevelAccessor)ctx.m_43725_(), ctx.m_8083_()));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.m_61124_(CONNECTED, (Comparable)this.getConnectedDirection(worldIn, currentPos));
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, KeroseneLampBlockEntity.class).ifPresent(KeroseneLampBlockEntity::removeLights);
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    private Direction getConnectedDirection(LevelAccessor world, BlockPos pos) {
        Direction connectedDir = Direction.DOWN;
        for (Direction d : DirectionUtil.VALUES) {
            BlockPos neighborPos = pos.m_142300_(d);
            if (!Block.m_49863_((LevelReader)world, (BlockPos)neighborPos, (Direction)d.m_122424_())) continue;
            connectedDir = d;
            break;
        }
        return connectedDir;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new KeroseneLampBlockEntity(pPos, pState);
    }

    public static class ItemBlockKeroseneLamp
    extends BlockItem
    implements ICustomTooltipName {
        public ItemBlockKeroseneLamp(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return (Boolean)ConfigHelper.common().machines.keroseneLampCanUseAnyFuel.get() != false ? this.m_5524_() : this.m_5524_() + ".kerosene_only";
        }
    }
}

