/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.AerialInterfaceMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.curios.CuriosUtils;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class AerialInterfaceBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<AerialInterfaceBlockEntity>,
IComparatorSupport,
ISideConfigurable,
MenuProvider {
    private static final UUID NO_PLAYER = new UUID(0L, 0L);
    private static final int ENERGY_CAPACITY = 100000;
    private static final int RF_PER_TICK = 1000;
    private static final int PLAYER_AIR_MULTIPLIER = 5;
    private static final List<RedstoneController.RedstoneMode<AerialInterfaceBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<AerialInterfaceBlockEntity>("standard.never", new ItemStack((ItemLike)Items.f_42403_), te -> false), new RedstoneController.EmittingRedstoneMode<AerialInterfaceBlockEntity>("aerialInterface.playerConnected", new ItemStack((ItemLike)ModBlocks.AERIAL_INTERFACE.get()), te -> te.isConnectedToPlayer));
    @DescSynced
    private String playerName = "";
    private UUID playerUUID = NO_PLAYER;
    private Fluid curXpFluid = Fluids.f_76191_;
    private int curXpRatio = 0;
    @GuiSynced
    public int curXPFluidIndex = -1;
    @GuiSynced
    public FeedMode feedMode = FeedMode.FRUGAL;
    private boolean oldRedstoneStatus;
    private boolean needUpdateNeighbours;
    @GuiSynced
    public boolean isConnectedToPlayer = false;
    @GuiSynced
    public boolean dispenserUpgradeInserted;
    @GuiSynced
    private final RedstoneController<AerialInterfaceBlockEntity> rsController = new RedstoneController<AerialInterfaceBlockEntity>(this, REDSTONE_MODES);
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private final PlayerExperienceHandler playerExperienceHandler = new PlayerExperienceHandler();
    private final LazyOptional<IFluidHandler> playerExpCap = LazyOptional.of(() -> this.playerExperienceHandler);
    private final PlayerFoodHandler playerFoodHandler = new PlayerFoodHandler();
    private final LazyOptional<IItemHandler> playerFoodCap = LazyOptional.of(() -> this.playerFoodHandler);
    private final PneumaticEnergyStorage energyStorage = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);
    private WeakReference<Player> playerRef = new WeakReference<Object>(null);
    private final List<Integer> chargeableSlots = new ArrayList<Integer>();
    private final List<PlayerInvHandler> invHandlers = new ArrayList<PlayerInvHandler>();
    public GameProfile gameProfileClient;

    public AerialInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.AERIAL_INTERFACE.get(), pos, state, PressureTier.TIER_TWO, 4000, 4);
        PlayerMainInvHandler playerMainInvHandler = new PlayerMainInvHandler();
        PlayerArmorInvHandler playerArmorInvHandler = new PlayerArmorInvHandler();
        PlayerOffhandInvHandler playerOffhandInvHandler = new PlayerOffhandInvHandler();
        PlayerEnderInvHandler playerEnderInvHandler = new PlayerEnderInvHandler();
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("mainInv", new ItemStack((ItemLike)Blocks.f_50087_), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerMainInvHandler), SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("armorInv", new ItemStack((ItemLike)ModItems.PNEUMATIC_CHESTPLATE.get()), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerArmorInvHandler), SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.registerHandler("offhandInv", new ItemStack((ItemLike)Items.f_42740_), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerOffhandInvHandler), new SideConfigurator.RelativeFace[0]);
        this.itemHandlerSideConfigurator.registerHandler("enderInv", new ItemStack((ItemLike)Blocks.f_50265_), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> playerEnderInvHandler), new SideConfigurator.RelativeFace[0]);
        this.invHandlers.add(playerMainInvHandler);
        this.invHandlers.add(playerArmorInvHandler);
        this.invHandlers.add(playerOffhandInvHandler);
        this.invHandlers.add(playerEnderInvHandler);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void m_6339_() {
        super.m_6339_();
        GlobalTileEntityCacheManager.getInstance().aerialInterfaces.add(this);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        GlobalTileEntityCacheManager.getInstance().aerialInterfaces.remove(this);
        this.itemHandlerSideConfigurator.invalidateCaps();
        this.playerExpCap.invalidate();
        this.playerFoodCap.invalidate();
        this.energyCap.invalidate();
    }

    public void setPlayer(Player player) {
        if (player == this.playerRef.get()) {
            return;
        }
        this.invHandlers.forEach(PlayerInvHandler::invalidate);
        this.playerRef = new WeakReference<Player>(player);
        boolean wasConnected = this.isConnectedToPlayer;
        if (player == null) {
            this.isConnectedToPlayer = false;
            this.playerName = "";
        } else {
            this.isConnectedToPlayer = true;
            this.playerName = player.m_36316_().getName();
            this.scanForChargeableItems(player);
        }
        if (wasConnected != this.isConnectedToPlayer) {
            this.needUpdateNeighbours = true;
            this.m_6596_();
        }
    }

    public void setPlayerId(UUID uuid) {
        this.playerUUID = uuid;
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        if (this.playerName.isEmpty()) {
            this.gameProfileClient = null;
        } else {
            SkullBlockEntity.m_155738_((GameProfile)new GameProfile(null, this.playerName), profile -> {
                this.gameProfileClient = profile;
            });
        }
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        boolean wasInserted = this.dispenserUpgradeInserted;
        boolean bl = this.dispenserUpgradeInserted = this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0;
        if (wasInserted != this.dispenserUpgradeInserted) {
            this.needUpdateNeighbours = true;
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.needUpdateNeighbours) {
            this.needUpdateNeighbours = false;
            this.updateNeighbours();
        }
        if (this.m_58904_() instanceof ServerLevel && (this.m_58904_().m_46467_() & 0xFL) == 0L) {
            this.setPlayer((Player)((ServerLevel)this.m_58904_()).m_142572_().m_6846_().m_11259_(this.playerUUID));
        }
        this.getPlayer().ifPresent(player -> {
            if (this.getPressure() >= this.getMinWorkingPressure()) {
                this.addAir(-1);
                if ((this.nonNullLevel().m_46467_() & 0x3FL) == 0L) {
                    this.scanForChargeableItems((Player)player);
                }
                this.supplyEnergyToPlayer((Player)player);
                this.supplyAirToPlayer((Player)player);
            }
        });
        if (this.oldRedstoneStatus != this.rsController.shouldEmit()) {
            this.oldRedstoneStatus = this.rsController.shouldEmit();
            this.needUpdateNeighbours = true;
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("xpType")) {
            ++this.curXPFluidIndex;
            List<Fluid> available = XPFluidManager.getInstance().getAvailableLiquidXPs();
            if (this.curXPFluidIndex >= available.size()) {
                this.curXPFluidIndex = -1;
            }
            this.curXpFluid = this.curXPFluidIndex >= 0 ? available.get(this.curXPFluidIndex) : Fluids.f_76191_;
            this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
        } else if (this.itemHandlerSideConfigurator.handleButtonPress(tag, shiftHeld)) {
            this.needUpdateNeighbours = true;
        } else {
            try {
                this.feedMode = FeedMode.valueOf(tag);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.m_6596_();
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    private Optional<Player> getPlayer() {
        Player player = (Player)this.playerRef.get();
        return player != null && player.m_6084_() ? Optional.of(player) : Optional.empty();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.dispenserUpgradeInserted) {
                return this.playerFoodCap.cast();
            }
            return this.itemHandlerSideConfigurator.getHandler(side).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dispenserUpgradeInserted && this.curXpFluid != Fluids.f_76191_) {
            return this.playerExpCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.playerUUID = UUID.fromString(tag.m_128461_("playerUUID"));
        this.feedMode = FeedMode.valueOf(tag.m_128461_("feedMode"));
        this.curXpFluid = tag.m_128441_("curXpFluid") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("curXpFluid"))) : Fluids.f_76191_;
        this.curXpRatio = XPFluidManager.getInstance().getXPRatio(this.curXpFluid);
        this.energyStorage.readFromNBT(tag);
        this.curXPFluidIndex = this.curXpFluid == Fluids.f_76191_ ? -1 : XPFluidManager.getInstance().getAvailableLiquidXPs().indexOf(this.curXpFluid);
        this.dispenserUpgradeInserted = this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("playerUUID", this.playerUUID.toString());
        tag.m_128359_("feedMode", this.feedMode.toString());
        tag.m_128359_("curXpFluid", this.curXpFluid.getRegistryName().toString());
        this.energyStorage.writeToNBT(tag);
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public int getComparatorValue() {
        return this.rsController.shouldEmit() ? 15 : 0;
    }

    private void scanForChargeableItems(Player player) {
        if (this.energyStorage.getEnergyStored() == 0) {
            return;
        }
        this.chargeableSlots.clear();
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!inv.m_8020_(i).getCapability(CapabilityEnergy.ENERGY).isPresent()) continue;
            this.chargeableSlots.add(i);
        }
    }

    private void supplyEnergyToPlayer(Player player) {
        if (this.energyStorage.getEnergyStored() > 0) {
            int slot;
            ItemStack stack;
            int energyLeft;
            Inventory inv = player.m_150109_();
            Iterator<Integer> iterator = this.chargeableSlots.iterator();
            while (iterator.hasNext() && (energyLeft = (stack = inv.m_8020_(slot = iterator.next().intValue())).getCapability(CapabilityEnergy.ENERGY).map(receivingStorage -> {
                int stored = this.energyStorage.getEnergyStored();
                if (stored > 0) {
                    this.energyStorage.extractEnergy(receivingStorage.receiveEnergy(Math.min(stored, 1000), false), false);
                }
                return this.energyStorage.getEnergyStored();
            }).orElse(this.energyStorage.getEnergyStored()).intValue()) != 0) {
            }
            if (Curios.available && this.energyStorage.getEnergyStored() > 0) {
                CuriosUtils.chargeItems(player, this.energyStorage, 1000);
            }
        }
    }

    private void supplyAirToPlayer(Player player) {
        if (player.m_20146_() <= 170) {
            int playerAir = 300 - player.m_20146_();
            player.m_20301_(300);
            this.addAir(-playerAir * 5);
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.SCUBA.get(), SoundSource.PLAYERS, player.m_142538_(), 1.0f, 0.9f, false), (ServerPlayer)player);
        }
    }

    @Override
    public List<SideConfigurator<?>> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new AerialInterfaceMenu(windowId, playerInventory, this.m_58899_());
    }

    @Override
    public RedstoneController<AerialInterfaceBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    private boolean hasEnoughPressure() {
        return this.getPressure() >= this.getMinWorkingPressure();
    }

    public static enum FeedMode implements ITranslatableEnum
    {
        FRUGAL("frugal", Items.f_42580_),
        GREEDY("greedy", Items.f_42410_),
        SMART("smart", Items.f_42436_);

        private final String key;
        private final ItemStack stack;

        private FeedMode(String key, Item item) {
            this.key = key;
            this.stack = new ItemStack((ItemLike)item);
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.info.aerialInterface.feedMode." + this.key;
        }

        public String getDescTranslationKey() {
            return this.getTranslationKey() + ".desc";
        }

        public ItemStack getIconStack() {
            return this.stack;
        }
    }

    private class PlayerExperienceHandler
    implements IFluidHandler {
        private PlayerExperienceHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (AerialInterfaceBlockEntity.this.curXpFluid != Fluids.f_76191_) {
                return AerialInterfaceBlockEntity.this.getPlayer().map(p -> new FluidStack(AerialInterfaceBlockEntity.this.curXpFluid, EnchantmentUtils.getPlayerXP(p) * AerialInterfaceBlockEntity.this.curXpRatio)).orElse(FluidStack.EMPTY);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return AerialInterfaceBlockEntity.this.curXpFluid != Fluids.f_76191_ && stack.getFluid() == AerialInterfaceBlockEntity.this.curXpFluid;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return AerialInterfaceBlockEntity.this.getPlayer().map(player -> {
                if (AerialInterfaceBlockEntity.this.curXpRatio != 0 && this.canFill(resource.getFluid())) {
                    int pointsAdded = resource.getAmount() / AerialInterfaceBlockEntity.this.curXpRatio;
                    if (doFill.execute()) {
                        player.m_6756_(pointsAdded);
                    }
                    return pointsAdded * AerialInterfaceBlockEntity.this.curXpRatio;
                }
                return 0;
            }).orElse(0);
        }

        private boolean canFill(Fluid fluid) {
            return AerialInterfaceBlockEntity.this.dispenserUpgradeInserted && fluid != Fluids.f_76191_ && fluid == AerialInterfaceBlockEntity.this.curXpFluid && AerialInterfaceBlockEntity.this.curXpRatio != 0 && AerialInterfaceBlockEntity.this.hasEnoughPressure();
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return AerialInterfaceBlockEntity.this.getPlayer().map(player -> {
                if (AerialInterfaceBlockEntity.this.curXpRatio != 0 && AerialInterfaceBlockEntity.this.dispenserUpgradeInserted && AerialInterfaceBlockEntity.this.hasEnoughPressure()) {
                    int pointsDrained = Math.min(EnchantmentUtils.getPlayerXP(player), resource.getAmount() / AerialInterfaceBlockEntity.this.curXpRatio);
                    if (doDrain.execute()) {
                        EnchantmentUtils.addPlayerXP(player, -pointsDrained);
                    }
                    return new FluidStack(resource.getFluid(), pointsDrained * AerialInterfaceBlockEntity.this.curXpRatio);
                }
                return FluidStack.EMPTY;
            }).orElse(FluidStack.EMPTY);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (AerialInterfaceBlockEntity.this.curXpFluid == Fluids.f_76191_) {
                return FluidStack.EMPTY;
            }
            return this.drain(new FluidStack(AerialInterfaceBlockEntity.this.curXpFluid, maxDrain), doDrain);
        }
    }

    private class PlayerFoodHandler
    implements IItemHandler {
        private PlayerFoodHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!AerialInterfaceBlockEntity.this.hasEnoughPressure()) {
                return stack;
            }
            return AerialInterfaceBlockEntity.this.getPlayer().map(player -> {
                if (this.getFoodValue(stack) <= 0 || !this.okToFeed(stack, (Player)player)) {
                    return stack;
                }
                if (simulate) {
                    return ItemStack.f_41583_;
                }
                int startValue = stack.m_41613_();
                ItemStack remainingItem = stack;
                ItemStack copy = stack.m_41777_();
                while (stack.m_41613_() > 0) {
                    remainingItem = stack.m_41671_(player.f_19853_, (LivingEntity)player);
                    if (!((remainingItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)stack, (int)0, (ItemStack)remainingItem)).m_41613_() <= 0 || remainingItem == stack && remainingItem.m_41613_() == startValue || player.m_150109_().m_36054_(remainingItem) || remainingItem.m_41613_() <= 0)) {
                        player.m_36176_(remainingItem, false);
                    }
                    player.m_5661_((Component)new TranslatableComponent("pneumaticcraft.gui.aerial_interface.fedItem", new Object[]{copy.m_41786_()}), true);
                    if (stack.m_41613_() != startValue) continue;
                }
                return remainingItem.m_41613_() > 0 ? remainingItem : ItemStack.f_41583_;
            }).orElse(stack);
        }

        private boolean okToFeed(@Nonnull ItemStack stack, Player player) {
            int foodValue = this.getFoodValue(stack);
            int curFoodLevel = player.m_36324_().m_38702_();
            FeedMode effectiveFeedMode = AerialInterfaceBlockEntity.this.feedMode == FeedMode.SMART ? (player.m_21223_() < player.m_21233_() ? FeedMode.GREEDY : FeedMode.FRUGAL) : AerialInterfaceBlockEntity.this.feedMode;
            return switch (effectiveFeedMode) {
                case FeedMode.FRUGAL -> {
                    if (20 - curFoodLevel >= foodValue * stack.m_41613_()) {
                        yield true;
                    }
                    yield false;
                }
                case FeedMode.GREEDY -> {
                    if (20 - curFoodLevel >= foodValue * (stack.m_41613_() - 1) + 1) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.getFoodValue(stack) > 0;
        }

        private int getFoodValue(ItemStack stack) {
            return stack.m_41720_().m_41472_() ? stack.m_41720_().m_41473_().m_38744_() : 0;
        }
    }

    private class PlayerMainInvHandler
    extends PlayerInvHandler {
        private PlayerMainInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, PlayerMainInvWrapper::new);
        }
    }

    private class PlayerArmorInvHandler
    extends PlayerInvHandler {
        private PlayerArmorInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, PlayerArmorInvWrapper::new);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStackInSlot(slot);
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44975_, (ItemStack)stack) > 0 ? ItemStack.f_41583_ : super.extractItem(slot, amount, simulate);
        }
    }

    private class PlayerOffhandInvHandler
    extends PlayerInvHandler {
        private PlayerOffhandInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            return this.getCachedHandler(player, PlayerOffhandInvWrapper::new);
        }
    }

    private class PlayerEnderInvHandler
    extends PlayerInvHandler {
        private PlayerEnderInvHandler() {
        }

        @Override
        protected IItemHandler getInvWrapper(Player player) {
            if (this.cached == null) {
                this.cached = new InvWrapper((Container)player.m_36327_());
            }
            return this.cached;
        }
    }

    private abstract class PlayerInvHandler
    implements IItemHandler {
        IItemHandler cached = null;

        private PlayerInvHandler() {
        }

        void invalidate() {
            this.cached = null;
        }

        IItemHandler getCachedHandler(Player p, Function<Inventory, IItemHandler> f) {
            if (this.cached == null) {
                this.cached = f.apply(p.m_150109_());
            }
            return this.cached;
        }

        protected abstract IItemHandler getInvWrapper(@Nonnull Player var1);

        public int getSlots() {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.hasEnoughPressure()).map(p -> this.getInvWrapper((Player)p).getSlots()).orElse(0);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.hasEnoughPressure()).map(p -> this.getInvWrapper((Player)p).getStackInSlot(slot)).orElse(ItemStack.f_41583_);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.hasEnoughPressure()).map(p -> this.getInvWrapper((Player)p).insertItem(slot, stack, simulate)).orElse(stack);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.hasEnoughPressure()).map(p -> this.getInvWrapper((Player)p).extractItem(slot, amount, simulate)).orElse(ItemStack.f_41583_);
        }

        public int getSlotLimit(int slot) {
            return AerialInterfaceBlockEntity.this.getPlayer().filter(p -> AerialInterfaceBlockEntity.this.hasEnoughPressure()).map(p -> this.getInvWrapper((Player)p).getSlotLimit(slot)).orElse(1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AerialInterfaceBlockEntity.this.hasEnoughPressure();
        }
    }
}

