/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.AirCompressorBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.AirCompressorMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;

public class AirCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<AirCompressorBlockEntity>,
MenuProvider {
    private static final int INVENTORY_SIZE = 1;
    private final AirCompressorFuelHandler itemHandler = new AirCompressorFuelHandler();
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> this.itemHandler);
    private static final int FUEL_SLOT = 0;
    @GuiSynced
    public int burnTime;
    @GuiSynced
    private int maxBurnTime;
    @GuiSynced
    public final RedstoneController<AirCompressorBlockEntity> rsController = new RedstoneController<AirCompressorBlockEntity>(this);
    @GuiSynced
    public int curFuelUsage;
    @GuiSynced
    public float airPerTick;
    private float airBuffer;

    public AirCompressorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.AIR_COMPRESSOR.get(), pos, state, PressureTier.TIER_ONE, 5000);
    }

    AirCompressorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volume) {
        super(type, pos, state, tier, volume, 4);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new AirCompressorMenu(i, playerInventory, this.m_58899_());
    }

    public boolean isActive() {
        return this.m_58900_().m_61138_((Property)AirCompressorBlock.ON) && (Boolean)this.m_58900_().m_61143_((Property)AirCompressorBlock.ON) != false;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.isActive()) {
            this.spawnBurningParticle();
        }
    }

    @Override
    public void tickServer() {
        BlockState state;
        boolean newIsActive;
        ItemStack fuelStack;
        int itemBurnTime;
        this.airPerTick = (float)this.getBaseProduction() * this.getSpeedMultiplierFromUpgrades() * (float)this.getHeatEfficiency() / 100.0f;
        if (this.rsController.shouldRun() && this.burnTime < this.curFuelUsage && (itemBurnTime = ForgeHooks.getBurnTime((ItemStack)(fuelStack = this.itemHandler.getStackInSlot(0)), (RecipeType)RecipeType.f_44108_)) > 0) {
            this.burnTime += itemBurnTime;
            this.maxBurnTime = this.burnTime;
            if (fuelStack.hasContainerItem()) {
                this.itemHandler.setStackInSlot(0, fuelStack.getContainerItem());
            } else {
                this.itemHandler.extractItem(0, 1, false);
            }
        }
        this.curFuelUsage = (int)((float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades() / 10.0f);
        if (this.burnTime >= this.curFuelUsage) {
            this.burnTime -= this.curFuelUsage;
            this.airBuffer += this.airPerTick;
            if (this.airBuffer >= 1.0f) {
                int toAdd = (int)this.airBuffer;
                this.addAir(toAdd);
                this.airBuffer -= (float)toAdd;
                this.addHeatForAir(toAdd);
            }
        }
        boolean bl = newIsActive = this.burnTime > this.curFuelUsage;
        if (this.isActive() != newIsActive && (state = this.m_58900_()).m_61138_((Property)AirCompressorBlock.ON)) {
            this.nonNullLevel().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)AirCompressorBlock.ON, (Comparable)Boolean.valueOf(newIsActive)));
        }
        this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation() : null);
    }

    protected void addHeatForAir(int air) {
    }

    public int getHeatEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    private void spawnBurningParticle() {
        Level level = this.nonNullLevel();
        if (level.f_46441_.nextInt(3) != 0) {
            return;
        }
        float px = (float)this.m_58899_().m_123341_() + 0.5f;
        float py = (float)this.m_58899_().m_123342_() + level.f_46441_.nextFloat() * 6.0f / 16.0f;
        float pz = (float)this.m_58899_().m_123343_() + 0.5f;
        float f3 = 0.5f;
        float f4 = level.f_46441_.nextFloat() * 0.4f - 0.2f;
        switch (this.getRotation()) {
            case EAST: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(px - f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)(px - f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(px + f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)(px + f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    public int getBurnTimeRemainingScaled(int parts) {
        if (this.maxBurnTime == 0 || this.burnTime < this.curFuelUsage) {
            return 0;
        }
        return parts * this.burnTime / this.maxBurnTime;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventory;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.burnTime = tag.m_128451_("burnTime");
        this.maxBurnTime = tag.m_128451_("maxBurn");
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("maxBurn", this.maxBurnTime);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public RedstoneController<AirCompressorBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    private class AirCompressorFuelHandler
    extends BaseItemStackHandler {
        AirCompressorFuelHandler() {
            super(AirCompressorBlockEntity.this, 1);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.m_41619_() || ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44108_) > 0 && FluidUtil.getFluidContained((ItemStack)itemStack).isEmpty());
        }
    }
}

