/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyDrillBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyIOUnitBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyLaserBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IResettable;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.inventory.AssemblyControllerMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AssemblyControllerBlockEntity
extends AbstractAirHandlingBlockEntity
implements IAssemblyMachine,
IMinWorkingPressure,
MenuProvider {
    private static final int PROGRAM_SLOT = 0;
    private static final int INVENTORY_SIZE = 1;
    private final ItemStackHandler itemHandler = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || itemStack.m_41720_() instanceof AssemblyProgramItem;
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    public AssemblyProgram curProgram;
    @GuiSynced
    public boolean isMachineMissing;
    @GuiSynced
    public boolean isMachineDuplicate;
    @GuiSynced
    public AssemblyProgram.EnumMachine missingMachine;
    @GuiSynced
    public AssemblyProgram.EnumMachine duplicateMachine;
    private boolean goingToHomePosition;
    @DescSynced
    public String displayedText = "";
    @DescSynced
    public boolean hasProblem;
    private AssemblySystem assemblySystem = null;

    public AssemblyControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ASSEMBLY_CONTROLLER.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        ItemStack programStack = this.itemHandler.getStackInSlot(0);
        AssemblyProgram newProgram = AssemblyProgramItem.getProgram(programStack);
        if (this.curProgram == null && !this.goingToHomePosition && newProgram != null) {
            this.curProgram = newProgram;
        } else if (this.curProgram != null && newProgram == null) {
            this.curProgram = null;
            if (!this.nonNullLevel().f_46443_) {
                this.goingToHomePosition = true;
            }
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.setStatus("Standby");
        if (this.getPressure() >= 3.5f && (this.curProgram != null || this.goingToHomePosition)) {
            if (this.assemblySystem == null) {
                this.assemblySystem = this.findAssemblySystem();
            }
            if (!(this.isMachineMissing && this.curProgram != null || this.isMachineDuplicate)) {
                boolean useAir;
                if (this.curProgram != null) {
                    useAir = this.curProgram.executeStep(this.assemblySystem);
                    if (useAir) {
                        this.setStatus("Running...");
                    }
                } else {
                    useAir = true;
                    boolean resetDone = this.assemblySystem.reset();
                    this.goingToHomePosition = this.isMachineMissing || !resetDone;
                    this.setStatus("Resetting...");
                }
                if (useAir) {
                    this.addAir(-((int)(2.0f * this.getSpeedUsageMultiplierFromUpgrades())));
                }
                this.assemblySystem.setSpeed(this.getSpeedMultiplierFromUpgrades());
            }
        }
        this.hasProblem = this.isMachineMissing || this.isMachineDuplicate || this.getPressure() < 3.5f || this.curProgram == null || this.curProgram.curProblem != AssemblyProgram.EnumAssemblyProblem.NO_PROBLEM;
    }

    void invalidateAssemblySystem() {
        this.assemblySystem = null;
    }

    private AssemblySystem findAssemblySystem() {
        AssemblyProgram.EnumMachine[] requiredMachines = this.curProgram != null ? this.curProgram.getRequiredMachines() : AssemblyProgram.EnumMachine.values();
        this.duplicateMachine = null;
        AssemblySystem assemblySystem = new AssemblySystem(this.m_58899_());
        for (IAssemblyMachine machine : this.findMachines(requiredMachines.length * 2)) {
            if (assemblySystem.addMachine(machine)) continue;
            this.duplicateMachine = machine.getAssemblyType();
        }
        this.missingMachine = assemblySystem.checkForMissingMachine(requiredMachines);
        this.isMachineDuplicate = this.duplicateMachine != null;
        this.isMachineMissing = this.missingMachine != null;
        return assemblySystem;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    private void setStatus(String text) {
        this.displayedText = text;
    }

    public List<IAssemblyMachine> findMachines(int max) {
        ArrayList<IAssemblyMachine> machineList = new ArrayList<IAssemblyMachine>();
        this.findMachines(machineList, this.m_58899_(), max);
        return machineList;
    }

    private void findMachines(List<IAssemblyMachine> machineList, BlockPos pos, int max) {
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            BlockEntity te = this.nonNullLevel().m_7702_(pos.m_142300_(dir));
            if (!(te instanceof IAssemblyMachine) || machineList.contains(te) || machineList.size() >= max) continue;
            machineList.add((IAssemblyMachine)te);
            this.findMachines(machineList, te.m_58899_(), max);
        }
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.invalidateAssemblySystem();
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1), (double)(this.m_58899_().m_123343_() + 1));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.goingToHomePosition = tag.m_128471_("goingToHomePosition");
        this.displayedText = tag.m_128461_("displayedText");
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        if (!this.itemHandler.getStackInSlot(0).m_41619_()) {
            this.curProgram = AssemblyProgramItem.getProgram(this.itemHandler.getStackInSlot(0));
            if (this.curProgram != null) {
                this.curProgram.readFromNBT(tag);
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("goingToHomePosition", this.goingToHomePosition);
        tag.m_128359_("displayedText", this.displayedText);
        if (this.curProgram != null) {
            this.curProgram.writeToNBT(tag);
        }
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public boolean isIdle() {
        return true;
    }

    @Override
    public void setSpeed(float speed) {
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.5f;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.CONTROLLER;
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new AssemblyControllerMenu(i, playerInventory, this.m_58899_());
    }

    public static class AssemblySystem {
        private final EnumMap<AssemblyProgram.EnumMachine, IAssemblyMachine> machines = new EnumMap(AssemblyProgram.EnumMachine.class);
        private final BlockPos controllerPos;

        public AssemblySystem(BlockPos controllerPos) {
            this.controllerPos = controllerPos;
        }

        private IAssemblyMachine get(AssemblyProgram.EnumMachine machine) {
            return this.machines.get(machine);
        }

        boolean addMachine(IAssemblyMachine machine) {
            if (this.machines.containsKey(machine.getAssemblyType())) {
                return false;
            }
            this.machines.put(machine.getAssemblyType(), machine);
            machine.setControllerPos(this.controllerPos);
            return true;
        }

        boolean reset() {
            boolean resetDone = true;
            for (IAssemblyMachine machine : this.machines.values()) {
                if (!(machine instanceof IResettable) || ((IResettable)((Object)machine)).reset()) continue;
                resetDone = false;
                if (!(machine instanceof AssemblyPlatformBlockEntity)) break;
                this.getExportUnit().pickupItem(null);
                break;
            }
            return resetDone;
        }

        void setSpeed(float speedMult) {
            this.machines.values().stream().filter(Objects::nonNull).forEach(te -> te.setSpeed(speedMult));
        }

        public AssemblyIOUnitBlockEntity getImportUnit() {
            return (AssemblyIOUnitBlockEntity)this.get(AssemblyProgram.EnumMachine.IO_UNIT_IMPORT);
        }

        public AssemblyIOUnitBlockEntity getExportUnit() {
            return (AssemblyIOUnitBlockEntity)this.get(AssemblyProgram.EnumMachine.IO_UNIT_EXPORT);
        }

        public AssemblyPlatformBlockEntity getPlatform() {
            return (AssemblyPlatformBlockEntity)this.get(AssemblyProgram.EnumMachine.PLATFORM);
        }

        public AssemblyLaserBlockEntity getLaser() {
            return (AssemblyLaserBlockEntity)this.get(AssemblyProgram.EnumMachine.LASER);
        }

        public AssemblyDrillBlockEntity getDrill() {
            return (AssemblyDrillBlockEntity)this.get(AssemblyProgram.EnumMachine.DRILL);
        }

        AssemblyProgram.EnumMachine checkForMissingMachine(AssemblyProgram.EnumMachine[] requiredMachines) {
            return Arrays.stream(requiredMachines).filter(e -> !this.machines.containsKey(e)).findFirst().orElse(null);
        }
    }
}

