/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

interface IAutoFluidEjecting {
    default public void autoExportFluid(AbstractPneumaticCraftBlockEntity te) {
        te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
            FluidStack toDrain = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!toDrain.isEmpty()) {
                Direction ejectDir = te.getUpgradeCache().getEjectDirection();
                if (ejectDir != null) {
                    this.tryEjectLiquid(te, (IFluidHandler)handler, ejectDir, toDrain.getAmount());
                } else {
                    for (Direction d : DirectionUtil.VALUES) {
                        toDrain.setAmount(toDrain.getAmount() - this.tryEjectLiquid(te, (IFluidHandler)handler, d, toDrain.getAmount()));
                        if (toDrain.getAmount() <= 0) break;
                    }
                }
            }
        });
    }

    default public int tryEjectLiquid(AbstractPneumaticCraftBlockEntity te, IFluidHandler handler, Direction dir, int amount) {
        BlockEntity teNeighbour = te.getCachedNeighbor(dir);
        if (teNeighbour != null) {
            return teNeighbour.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.m_122424_()).map(destHandler -> {
                FluidStack fluidStack = FluidUtil.tryFluidTransfer((IFluidHandler)destHandler, (IFluidHandler)handler, (int)amount, (boolean)true);
                return fluidStack.getAmount();
            }).orElse(0);
        }
        return 0;
    }
}

