/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.KeroseneLampBlock;
import me.desht.pneumaticcraft.common.block.KeroseneLampLightBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.inventory.KeroseneLampMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class KeroseneLampBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<KeroseneLampBlockEntity>,
ISerializableTanks,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<KeroseneLampBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("standard.always", new ItemStack((ItemLike)Items.f_42403_), te -> true), new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.f_42451_), te -> te.getCurrentRedstonePower() > 0), new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("standard.low_signal", new ItemStack((ItemLike)Items.f_41978_), te -> te.getCurrentRedstonePower() == 0), new RedstoneController.ReceivingRedstoneMode<KeroseneLampBlockEntity>("keroseneLamp.interpolate", new ItemStack((ItemLike)Items.f_42351_), te -> te.getCurrentRedstonePower() > 0));
    public static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int RS_MODE_INTERPOLATE = 3;
    private static final int LIGHT_SPACING = 3;
    public static final int MAX_RANGE = 30;
    private final Set<BlockPos> managingLights = new HashSet<BlockPos>();
    private boolean isOn;
    @GuiSynced
    private int range;
    @GuiSynced
    private int targetRange = 10;
    @GuiSynced
    private final RedstoneController<KeroseneLampBlockEntity> rsController = new RedstoneController<KeroseneLampBlockEntity>(this, REDSTONE_MODES);
    @GuiSynced
    private int fuel;
    private int checkingX;
    private int checkingY;
    private int checkingZ;
    private int rangeSq;
    @DescSynced
    @GuiSynced
    private final SmartSyncTank tank = new SmartSyncTank(this, 2000){

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
            super.onContentsChanged(prevFluid, prevAmount);
            if (prevFluid != this.fluid.getFluid()) {
                KeroseneLampBlockEntity.this.recalculateFuelQuality();
            }
        }
    };
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    @DescSynced
    private float fuelQuality = -1.0f;
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public KeroseneLampBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.KEROSENE_LAMP.get()), pos, state);
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        Level level = this.nonNullLevel();
        if (((Boolean)this.m_58900_().m_61143_((Property)KeroseneLampBlock.LIT)).booleanValue() && level.f_46441_.nextInt(10) == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)this.m_58899_().m_123341_() + 0.4 + 0.2 * level.f_46441_.nextDouble(), (double)this.m_58899_().m_123342_() + 0.2 + (double)this.tank.getFluidAmount() / 1000.0 * 3.0 / 16.0, (double)this.m_58899_().m_123343_() + 0.4 + 0.2 * level.f_46441_.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.fuelQuality < 0.0f) {
            this.recalculateFuelQuality();
        }
        this.processFluidItem(0, 1);
        if (this.nonNullLevel().m_46467_() % 5L == 0L) {
            int effectiveRange;
            int n = effectiveRange = this.rsController.shouldRun() && this.fuel > 0 ? this.targetRange : 0;
            if (this.rsController.getCurrentMode() == 3) {
                effectiveRange = (int)((double)this.rsController.getCurrentRedstonePower() / 15.0 * (double)this.targetRange);
            }
            this.updateRange(Math.min(effectiveRange, this.tank.getFluidAmount()));
            this.updateLights();
            this.useFuel();
        }
    }

    private void recalculateFuelQuality() {
        if (!this.tank.isEmpty()) {
            if (((Boolean)ConfigHelper.common().machines.keroseneLampCanUseAnyFuel.get()).booleanValue()) {
                this.fuelQuality = (float)PneumaticRegistry.getInstance().getFuelRegistry().getFuelValue(this.f_58857_, this.tank.getFluid().getFluid()) / 110.0f;
            } else {
                float f = this.fuelQuality = this.tank.getFluid().getFluid() == ModFluids.KEROSENE.get() ? 10000.0f : 0.0f;
            }
            if (this.tank.getFluid().getFluid().m_205067_(PneumaticCraftTags.Fluids.KEROSENE)) {
                this.fuelQuality *= 2.5f;
            }
            this.fuelQuality = (float)((double)this.fuelQuality * (Double)ConfigHelper.common().machines.keroseneLampFuelEfficiency.get());
        }
    }

    private void useFuel() {
        if (this.fuelQuality == 0.0f) {
            return;
        }
        this.fuel -= this.rangeSq * 3;
        while (this.fuel <= 0 && !this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
            this.fuel = (int)((float)this.fuel + this.fuelQuality);
        }
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    public void m_6339_() {
        super.m_6339_();
        this.checkingX = this.m_58899_().m_123341_();
        this.checkingY = this.m_58899_().m_123342_();
        this.checkingZ = this.m_58899_().m_123343_();
    }

    public void removeLights() {
        for (BlockPos pos : this.managingLights) {
            if (!this.nonNullLevel().m_46749_(pos) || !this.isLampLight(pos)) continue;
            this.nonNullLevel().m_7471_(pos, false);
        }
    }

    private boolean isLampLight(BlockPos pos) {
        return this.nonNullLevel().m_8055_(pos).m_60734_() == ModBlocks.KEROSENE_LAMP_LIGHT.get();
    }

    private void updateLights() {
        int roundedRange = this.range / 3 * 3;
        this.checkingX += 3;
        if (this.checkingX > this.m_58899_().m_123341_() + roundedRange) {
            this.checkingX = this.m_58899_().m_123341_() - roundedRange;
            this.checkingY += 3;
            if (this.checkingY > this.m_58899_().m_123342_() + roundedRange) {
                this.checkingY = this.m_58899_().m_123342_() - roundedRange;
                this.checkingZ += 3;
                if (this.checkingZ > this.m_58899_().m_123343_() + roundedRange) {
                    this.checkingZ = this.m_58899_().m_123343_() - roundedRange;
                }
            }
        }
        BlockPos pos = new BlockPos(this.checkingX, this.checkingY, this.checkingZ);
        if (!this.nonNullLevel().m_46749_(pos)) {
            return;
        }
        if (this.managingLights.contains(pos)) {
            if (this.isLampLight(pos)) {
                if (!this.passesRaytraceTest(pos, this.m_58899_())) {
                    this.nonNullLevel().m_7471_(pos, false);
                    this.managingLights.remove(pos);
                }
            } else {
                this.managingLights.remove(pos);
            }
        } else {
            this.tryAddLight(pos);
        }
    }

    private void updateRange(int targetRange) {
        if (targetRange > this.range) {
            ++this.range;
            int roundedRange = this.range / 3 * 3;
            for (int x = -roundedRange; x <= roundedRange; x += 3) {
                for (int y = -roundedRange; y <= roundedRange; y += 3) {
                    for (int z = -roundedRange; z <= roundedRange; z += 3) {
                        BlockPos pos = this.m_58899_().m_142082_(x, y, z);
                        if (this.managingLights.contains(pos)) continue;
                        this.tryAddLight(pos);
                    }
                }
            }
        } else if (targetRange < this.range) {
            --this.range;
            Iterator<BlockPos> iterator = this.managingLights.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = iterator.next();
                if (!this.nonNullLevel().m_46749_(pos)) continue;
                if (!this.isLampLight(pos)) {
                    iterator.remove();
                    continue;
                }
                if (!(PneumaticCraftUtils.distBetweenSq(pos, this.m_58899_()) > (double)this.rangeSq)) continue;
                this.nonNullLevel().m_7471_(pos, false);
                iterator.remove();
            }
        }
        this.rangeSq = this.range * this.range;
        boolean wasOn = this.isOn;
        boolean bl = this.isOn = this.range > 0;
        if (this.isOn != wasOn) {
            this.nonNullLevel().m_7726_().m_7827_().m_142202_(this.m_58899_());
            this.nonNullLevel().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)KeroseneLampBlock.LIT, (Comparable)Boolean.valueOf(this.isOn)));
        }
    }

    private boolean passesRaytraceTest(BlockPos pos, BlockPos lampPos) {
        ClipContext ctx = new ClipContext(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), new Vec3((double)lampPos.m_123341_() + 0.5, (double)lampPos.m_123342_() + 0.5, (double)lampPos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.m_58904_())));
        BlockHitResult rtr = this.nonNullLevel().m_45547_(ctx);
        return rtr.m_6662_() == HitResult.Type.BLOCK && rtr.m_82425_().equals((Object)lampPos);
    }

    private void tryAddLight(BlockPos pos) {
        if (!((Boolean)ConfigHelper.common().advanced.disableKeroseneLampFakeAirBlock.get()).booleanValue() && this.nonNullLevel().m_46749_(pos) && PneumaticCraftUtils.distBetweenSq(pos, this.m_58899_()) <= (double)this.rangeSq && this.nonNullLevel().m_46859_(pos) && !this.isLampLight(pos) && this.passesRaytraceTest(pos, this.m_58899_())) {
            this.nonNullLevel().m_46597_(pos, ((KeroseneLampLightBlock)((Object)ModBlocks.KEROSENE_LAMP_LIGHT.get())).m_49966_());
            this.managingLights.add(pos);
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onDescUpdate() {
        this.nonNullLevel().m_7726_().m_7827_().m_142202_(this.m_58899_());
        super.onDescUpdate();
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("lights", (Tag)this.managingLights.stream().map(NbtUtils::m_129224_).collect(Collectors.toCollection(ListTag::new)));
        tag.m_128344_("targetRange", (byte)this.targetRange);
        tag.m_128344_("range", (byte)this.range);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.managingLights.clear();
        ListTag lights = tag.m_128437_("lights", 10);
        for (int i = 0; i < lights.size(); ++i) {
            this.managingLights.add(NbtUtils.m_129239_((CompoundTag)lights.m_128728_(i)));
        }
        this.recalculateFuelQuality();
        this.targetRange = tag.m_128445_("targetRange");
        this.range = tag.m_128445_("range");
        this.rangeSq = this.range * this.range;
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public RedstoneController<KeroseneLampBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.targetRange = Mth.m_14045_((int)Integer.parseInt(tag), (int)1, (int)30);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public SmartSyncTank getTank() {
        return this.tank;
    }

    public int getRange() {
        return this.range;
    }

    public int getTargetRange() {
        return this.targetRange;
    }

    public int getFuel() {
        return this.fuel;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, facing);
    }

    public float getFuelQuality() {
        return this.fuelQuality;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new KeroseneLampMenu(i, playerInventory, this.m_58899_());
    }
}

