/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.RefineryControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.RefineryMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class RefineryOutputBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<RefineryOutputBlockEntity>,
IComparatorSupport,
ISerializableTanks,
MenuProvider,
IHeatExchangingTE {
    private RefineryControllerBlockEntity controllerTE = null;
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.outputTank);
    private final LazyOptional<IFluidHandler> fluidCapWrapped = LazyOptional.of(() -> new TankWrapper(this.outputTank));
    private final RedstoneController<RefineryOutputBlockEntity> rsController = new RedstoneController<RefineryOutputBlockEntity>(this);

    public RefineryOutputBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.REFINERY_OUTPUT.get()), pos, state);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.outputTank.tick();
    }

    @Override
    public int getComparatorValue() {
        RefineryControllerBlockEntity controller = this.getRefineryController();
        return controller == null ? 0 : controller.getComparatorValue();
    }

    @Override
    public RedstoneController<RefineryOutputBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public int getRedstoneMode() {
        RefineryControllerBlockEntity controller = this.getRefineryController();
        return controller == null ? 0 : controller.getRedstoneMode();
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.outputTank);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        RefineryControllerBlockEntity controller = this.getRefineryController();
        return controller == null ? null : new RefineryMenu(windowId, inventory, controller.m_58899_());
    }

    public RefineryControllerBlockEntity getRefineryController() {
        if (this.controllerTE != null && this.controllerTE.m_58901_()) {
            this.controllerTE = null;
        }
        if (this.controllerTE == null) {
            Level level = this.nonNullLevel();
            BlockPos checkPos = this.f_58858_;
            while (level.m_8055_(checkPos.m_7495_()).m_60734_() == ModBlocks.REFINERY_OUTPUT.get()) {
                checkPos = checkPos.m_7495_();
            }
            if (level.m_8055_(checkPos.m_7495_()).m_60734_() == ModBlocks.REFINERY.get()) {
                this.controllerTE = (RefineryControllerBlockEntity)level.m_7702_(checkPos.m_7495_());
            } else {
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    if (level.m_8055_(checkPos.m_142300_(d)).m_60734_() != ModBlocks.REFINERY.get()) continue;
                    this.controllerTE = (RefineryControllerBlockEntity)level.m_7702_(checkPos.m_142300_(d));
                }
            }
        }
        return this.controllerTE;
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return side == Direction.DOWN ? this.fluidCap.cast() : this.fluidCapWrapped.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.fluidCap.invalidate();
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    private record TankWrapper(SmartSyncTank wrapped) implements IFluidHandler
    {
        public int getTanks() {
            return this.wrapped.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.wrapped.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrapped.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.wrapped.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.wrapped.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.wrapped.drain(maxDrain, action);
        }
    }
}

