/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.AirConHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.BlockTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.EntityTrackerHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.SearchHandler;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.resources.ResourceLocation;

public class ArmorHUDLayout
extends AuxConfigJson {
    public static final ArmorHUDLayout INSTANCE = new ArmorHUDLayout();
    private static final String HUD_LAYOUT = "hud_layout";
    private final Map<ResourceLocation, StatPanelLayout> layouts = new HashMap<ResourceLocation, StatPanelLayout>();

    private ArmorHUDLayout() {
        super(true);
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("Description", "Stores the layout of Pneumatic Armor HUD elements");
        JsonObject sub = new JsonObject();
        this.layouts.forEach((id, layout) -> sub.add(id.toString(), (JsonElement)layout.toJson()));
        json.add(HUD_LAYOUT, (JsonElement)sub);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        if (json.has("stats")) {
            this.loadLegacy(json.getAsJsonObject("stats"));
        } else if (json.has(HUD_LAYOUT)) {
            JsonObject sub = json.getAsJsonObject(HUD_LAYOUT);
            sub.entrySet().forEach(entry -> {
                try {
                    ResourceLocation id = new ResourceLocation((String)entry.getKey());
                    this.layouts.put(id, StatPanelLayout.fromJson(((JsonElement)entry.getValue()).getAsJsonObject()));
                }
                catch (IllegalArgumentException e) {
                    Log.error("invalid stat panel key (not a resource location) %s in %s!", entry.getKey(), this.getConfigFilename());
                }
                catch (IllegalStateException | NullPointerException e) {
                    Log.error("invalid json for key %s in %s!", entry.getKey(), this.getConfigFilename());
                }
            });
        }
    }

    private void loadLegacy(JsonObject json) {
        this.maybeAddLegacy(json, CoreComponentsHandler.ID, "power");
        this.maybeAddLegacy(json, CoreComponentsHandler.getMessageID(), "message");
        this.maybeAddLegacy(json, BlockTrackerHandler.ID, "blockTracker");
        this.maybeAddLegacy(json, EntityTrackerHandler.ID, "entityTracker");
        this.maybeAddLegacy(json, SearchHandler.ID, "itemSearch");
        this.maybeAddLegacy(json, AirConHandler.ID, "airCon");
        this.maybeAddLegacy(json, JetBootsHandler.ID, "jetBoots");
    }

    private void maybeAddLegacy(JsonObject json, ResourceLocation id, String fieldName) {
        if (json.has(fieldName)) {
            this.layouts.put(id, StatPanelLayout.fromJson(json.get(fieldName).getAsJsonObject()));
        }
    }

    @Override
    public String getConfigFilename() {
        return "PneumaticArmorHUDLayout";
    }

    public void updateLayout(ResourceLocation id, float x, float y, boolean leftSided) {
        this.layouts.put(id, new StatPanelLayout(x, y, leftSided));
        this.tryWriteToFile();
    }

    public StatPanelLayout getLayoutFor(ResourceLocation upgradeID, StatPanelLayout defaultStatLayout) {
        return this.layouts.computeIfAbsent(upgradeID, k -> defaultStatLayout);
    }
}

