/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import java.io.File;
import java.io.IOException;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.config.subconfig.ProgWidgetConfig;
import me.desht.pneumaticcraft.common.config.subconfig.ThirdPartyConfig;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;

public class AuxConfigHandler {
    private static final LevelResource FOLDER = new LevelResource("pneumaticcraft");
    private static final IAuxConfig[] EXTERNAL_CONFIGS = new IAuxConfig[]{AmadronPlayerOffers.INSTANCE, ProgWidgetConfig.INSTANCE, ArmorFeatureStatus.INSTANCE, ThirdPartyConfig.INSTANCE, MicromissileDefaults.INSTANCE, ArmorHUDLayout.INSTANCE};

    public static void preInit() {
        File defaultConfigDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "pneumaticcraft");
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            if (subConfig.useWorldSpecificDir() || !defaultConfigDir.exists() && !defaultConfigDir.mkdirs()) continue;
            File subFile = new File(defaultConfigDir, subConfig.getConfigFilename() + ".cfg");
            try {
                subConfig.preInit(subFile);
            }
            catch (IOException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " failed to create! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " appears to be invalid JSON! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public static void postInit() {
        File defaultConfigDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "pneumaticcraft");
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            File subFolder;
            if (subConfig.useWorldSpecificDir() && ServerLifecycleHooks.getCurrentServer() == null) continue;
            File file = subFolder = subConfig.useWorldSpecificDir() ? AuxConfigHandler.getWorldSpecificDir() : defaultConfigDir;
            if (!subFolder.exists() && !subFolder.mkdirs()) continue;
            File subFile = new File(subFolder, subConfig.getConfigFilename() + ".cfg");
            if (!subFile.exists() && subConfig.useWorldSpecificDir()) {
                AuxConfigHandler.maybeMigrateFile(new File(defaultConfigDir, subConfig.getConfigFilename() + ".cfg"), subFile);
            }
            try {
                subConfig.postInit(subFile);
            }
            catch (IOException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " failed to create! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                Log.error("Config file " + subConfig.getConfigFilename() + " appears to be invalid JSON! Unexpected things can happen!", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    private static void maybeMigrateFile(File oldFile, File newFile) {
        try {
            if (oldFile.exists()) {
                FileUtils.moveFile((File)oldFile, (File)newFile);
                Log.info("Migrated " + oldFile + " to " + newFile, new Object[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getWorldSpecificDir() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(FOLDER).toFile();
    }

    public static void clearPerWorldConfigs() {
        for (IAuxConfig subConfig : EXTERNAL_CONFIGS) {
            if (!subConfig.useWorldSpecificDir()) continue;
            subConfig.clear();
        }
    }
}

